/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.ConnectionPropertyView;
import com.sas.workspace.mgmt.visuals.ConnectionTypeView;
import com.sas.workspace.mgmt.visuals.GeneralPropertyView;
import com.sas.workspace.mgmt.visuals.SASAppServerTypeView;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ConnectionWizard
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected Connection m_connection;
    protected ServerComponent m_serverComponent;
    protected JFrame m_frame;
    protected Dialog m_dialog;
    protected Component m_component;
    protected String m_strContext;
    protected String m_strTitle;
    protected MdObjectStore m_objectStore = null;
    protected Prototype m_serverPrototype;
    protected SASAppServerTypeView m_appTab;
    protected boolean m_bShowWizard = true;
    boolean bComplete = false;
    private static final WAdminResource bundle = WAdminResource.getBundle(ConnectionWizard.class);

    public ConnectionWizard(JFrame frame, String strContext, ServerComponent serverComponent) {
        super((Frame)frame, true);
        this._init(frame, strContext, serverComponent, null);
    }

    public ConnectionWizard(JFrame frame, String strContext, ServerComponent serverComponent, MdObjectStore store) {
        super((Frame)frame, true);
        this._init(frame, strContext, serverComponent, store);
    }

    public ConnectionWizard(Dialog dialog, String strContext, ServerComponent serverComponent) {
        super(dialog, true);
        this._init(dialog, strContext, serverComponent, null);
    }

    public ConnectionWizard(Dialog dialog, String strContext, ServerComponent serverComponent, MdObjectStore store) {
        super(dialog, true);
        this._init(dialog, strContext, serverComponent, store);
    }

    private void _init(Component comp, String strContext, ServerComponent serverComponent, MdObjectStore store) {
        try {
            String strTitle;
            ServerComponent tempServerComponent;
            this.setHelpProduct("newserver");
            if (store != null) {
                this.m_objectStore = store;
                this.m_objectStore.setIsObjectCopiedFromParentOnCreation(false);
            } else {
                Object storedata = this.getWizardData("OBJECTSTORE");
                if (storedata instanceof MdObjectStore) {
                    this.m_objectStore = (MdObjectStore)storedata;
                    this.m_objectStore.setIsObjectCopiedFromParentOnCreation(false);
                }
            }
            this.m_serverComponent = tempServerComponent = (ServerComponent)Workspace.getMdFactory().createComplexMetadataObject(this.m_objectStore, null, serverComponent.getName(), serverComponent.getCMetadataType(), serverComponent.getId(), null);
            this.m_server = new Server(this.m_objectStore, strContext, (DeployedComponent)tempServerComponent);
            this.m_server.setParentComponent(comp);
            this.m_component = comp;
            this.m_strContext = strContext;
            this.m_strTitle = strTitle = bundle.getString("ConnectionWizard.Title.txt");
            WATransitionWizardModel model = new WATransitionWizardModel();
            this.setWizardModel((WAWizardModel)model);
            this.m_serverPrototype = this.m_server.getDeployedComponentPrototype((Component)((Object)this));
            AssociationList associationsList = this.m_serverPrototype.getAssociations();
            for (int i = 0; i < associationsList.size(); ++i) {
                AssociationList assocPrototypesList;
                AssociationProperty property = (AssociationProperty)associationsList.get(i);
                if (!property.getAssociationName().equals("SourceConnections") || (assocPrototypesList = property.getAssociatedPrototypes()).size() <= 2) continue;
                ConnectionTypeView connTypeTab = new ConnectionTypeView();
                this.addTab(strTitle, "ConnectionType", (WAPropertyTab)connTypeTab, bundle.getString("ServerWizard.ConnectionInfoImage.image"), bundle.getImageIcon("ServerWizard.ConnectionInfoImage.image"));
                String[][] transitions = new String[][]{{"ConnectionType", "NEXT", "General"}};
                model.addTransitions(transitions);
                break;
            }
            this.addWizardTabs(model, strTitle);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
        }
    }

    public Root getMetadataObject() {
        return (Root)this.getWizardData("DeployedComponent");
    }

    public String getTitle() {
        return this.m_strTitle;
    }

    public void setPreferredSize(Dimension dimension) {
        this.getMainPanel().setPreferredSize(dimension);
    }

    public void show() {
        boolean bShowWizard = true;
        this.m_component.setCursor(Cursor.getPredefinedCursor(3));
        try {
            boolean bFoundConnectionPrototype = false;
            AssociationList associationsList = this.m_serverPrototype.getAssociations();
            for (int index = 0; index < associationsList.size(); ++index) {
                AssociationProperty property = (AssociationProperty)associationsList.get(index);
                if (!property.getAssociationName().equals("SourceConnections")) continue;
                bFoundConnectionPrototype = true;
                break;
            }
            if (!bFoundConnectionPrototype) {
                JOptionPane.showMessageDialog((Component)((Object)this), bundle.getString("ConnectionWizard.CannotAddConnection.txt"), bundle.getString("Common.Information.txt"), 1);
                bShowWizard = false;
                this.m_component.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            boolean bIsConnectServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06");
            boolean bIsGridServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("D7E796B4-654C-4ab3-B690-657EE79309FB");
            boolean bIsOSSchedulerServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd");
            boolean bIsIOMServer = false;
            AssociationList serviceTypeList = this.m_serverComponent.getServiceTypes();
            for (int typeIndex = 0; typeIndex < serviceTypeList.size(); ++typeIndex) {
                ServiceType serviceType = (ServiceType)serviceTypeList.get(typeIndex);
                if (!serviceType.getName().equals("IOM Server")) continue;
                bIsIOMServer = true;
                break;
            }
            boolean bIsMetadataServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836");
            boolean bIsTableServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc");
            boolean bIsPooledWorkspaceServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb");
            boolean bIsHttpServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("DAC0D7F0-10DA-11D6-8816-AA0004006D06");
            boolean bIsFtpServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("CBA26437-1577-4FF8-93F6-9B68B4DD8D2E");
            boolean bIsMSMQServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("MessageQueue.MSMQ");
            boolean bIsWebsphereMQServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("MessageQueue.Websphere");
            boolean bIsLASRServer = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("SASIOLA");
            boolean bIsConnectSpawner = this.m_serverComponent.getClassIdentifier().equalsIgnoreCase("Connect Spawner");
            if (bIsConnectServer || bIsGridServer || bIsHttpServer || bIsFtpServer || bIsPooledWorkspaceServer || bIsOSSchedulerServer || bIsMSMQServer || bIsWebsphereMQServer || bIsLASRServer || bIsConnectSpawner) {
                bShowWizard = this.showAllowOneConnectionWizard(this.m_serverComponent);
            } else if (bIsIOMServer) {
                bShowWizard = bIsTableServer || bIsMetadataServer ? true : this._showIOMServerConnectionWizard(this.m_serverComponent);
            }
            this.m_component.setCursor(Cursor.getPredefinedCursor(0));
            if (bShowWizard) {
                super.show();
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
        }
    }

    protected void addWizardTabs(WATransitionWizardModel model, String strTitle) {
        this.setTitle(strTitle);
        GeneralPropertyView generalTab = new GeneralPropertyView(this.m_connection, 0);
        this.addTab(strTitle, "General", (WAPropertyTab)generalTab, bundle.getString("Common.NameDescriptionTab.image"), bundle.getImageIcon("Common.NameDescriptionTab.image"));
        ConnectionPropertyView connectionTab = new ConnectionPropertyView(0);
        this.addTab(strTitle, "Connection", (WAPropertyTab)connectionTab, bundle.getString("ServerWizard.ConnectionInfoImage.image"), bundle.getImageIcon("ServerWizard.ConnectionInfoImage.image"));
        WizardFinishTab finishTab = new WizardFinishTab(bundle.getString("ConnectionWizard.DefinitionSuccess.txt"));
        this.addTab(strTitle, "Completion", (WAPropertyTab)finishTab, bundle.getString("Common.FinishTab.image"), bundle.getImageIcon("Common.FinishTab.image"));
        String[][] transitions = new String[][]{{"General", "NEXT", "Connection"}, {"Connection", "NEXT", "Completion"}};
        model.addTransitions(transitions);
        this.addWizardData("Server", this.m_server);
        this.addWizardData("DeployedComponent", this.m_serverComponent);
        try {
            this.addWizardData("DeployedComponentPrototype", this.m_serverPrototype);
            AssociationList usedByComponentsList = this.m_serverComponent.getUsedByComponents();
            if (usedByComponentsList.size() > 0 && usedByComponentsList.get(0) instanceof LogicalServer) {
                this.addWizardData("LogicalServer", usedByComponentsList.get(0));
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
        }
    }

    public boolean onCompletion() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.m_server.persist();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Writing");
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return super.onFinish();
    }

    protected boolean onFinish() {
        this.dispose();
        OpRequestUI request = new OpRequestUI((JDialog)((Object)this), bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt"), bundle.getString("WriteMetadataProgressIndicator.Msg.Title"));
        Runnable runOnCompletion = new Runnable(){

            @Override
            public void run() {
                ConnectionWizard.this.bComplete = ConnectionWizard.this.onCompletion();
            }
        };
        request.execute(runOnCompletion);
        return this.bComplete;
    }

    protected boolean showAllowOneConnectionWizard(ServerComponent serverComponent) {
        boolean bShow = true;
        try {
            AssociationList connectionsList = serverComponent.getSourceConnections();
            if (connectionsList.size() > 0) {
                JOptionPane.showMessageDialog((Component)Workspace.getWorkspace(), bundle.getString("ConnectionWizard.NoMoreServerConnections.txt"), bundle.getString("Common.Information.txt"), 1);
                bShow = false;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
        }
        return bShow;
    }

    protected boolean _showIOMServerConnectionWizard(ServerComponent serverComponent) {
        Vector<String> protocolList = new Vector<String>(1);
        protocolList.add("Bridge");
        boolean bShow = true;
        try {
            Transformation transform;
            AssociationList initProcessesList;
            AssociationList connectionsList = serverComponent.getSourceConnections();
            for (int connIndex = 0; connIndex < connectionsList.size(); ++connIndex) {
                Connection connection = (Connection)connectionsList.get(connIndex);
                String strAppProtocol = connection.getApplicationProtocol();
                if (!protocolList.contains(strAppProtocol)) continue;
                protocolList.remove(strAppProtocol);
            }
            boolean bIsLoadBalanced = false;
            LogicalServer logicalServer = (LogicalServer)serverComponent.getUsedByComponents().get(0);
            if (logicalServer != null && (initProcessesList = logicalServer.getInitProcesses()).size() > 0 && (transform = (Transformation)initProcessesList.get(0)).getTransformRole().equals("Load Balancing")) {
                bIsLoadBalanced = true;
            }
            if (bIsLoadBalanced && serverComponent.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                protocolList.add("MultiBridge");
            }
            if (protocolList.size() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ConnectionWizard.NoMoreServerConnections.txt"), (String)bundle.getString("Common.Information.txt"), (int)1);
                bShow = false;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
        }
        return bShow;
    }
}

