/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.AttributeProperty;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.PrototypeProperty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ConnectionTypeView
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected SASClientConnection m_sasConnection;
    protected TCPIPConnection m_tcpConnection;
    protected COMConnection m_comConnection;
    protected List m_connectionPrototypeList;
    protected List m_radioPrototypePairList;
    private static final WAdminResource bundle = WAdminResource.getBundle(ConnectionTypeView.class);

    public ConnectionTypeView() {
        super(bundle.getString("ConnectionTypeView.Title.txt"));
        this._initialize();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            try {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                Prototype prototype = (Prototype)parent.getWizardData("DeployedComponentPrototype");
                AssociationList propertiesList = prototype.getAssociations();
                this.m_connectionPrototypeList = new Vector();
                for (int i = 0; i < propertiesList.size(); ++i) {
                    AssociationProperty assocProperty = (AssociationProperty)propertiesList.get(i);
                    if (!assocProperty.getAssociationName().equals("SourceConnections")) continue;
                    AssociationList connectionPrototypeList = assocProperty.getAssociatedPrototypes();
                    for (int cpIndex = 0; cpIndex < connectionPrototypeList.size(); ++cpIndex) {
                        Prototype connPrototype = (Prototype)connectionPrototypeList.get(cpIndex);
                        if (connPrototype == prototype) continue;
                        this.m_connectionPrototypeList.add(connPrototype);
                    }
                    break;
                }
                this.removeAll();
                this._layoutWidgets();
                this.revalidate();
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
            }
        }
        return false;
    }

    public boolean validateData() {
        return true;
    }

    public void onNext() {
        block42: {
            try {
                ServerComponent serverComponent;
                Hashtable pTable;
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                Prototype previousPrototype = (Prototype)parent.getWizardData("ConnectionPrototype");
                for (int i = 0; i < this.m_radioPrototypePairList.size(); ++i) {
                    RadioPrototypePair pair = (RadioPrototypePair)this.m_radioPrototypePairList.get(i);
                    if (!pair.m_radio.isSelected()) continue;
                    parent.replaceWizardData("ConnectionPrototype", (Object)pair.m_prototype);
                    Server server = (Server)parent.getWizardData("Server");
                    ServerComponent serverComponent2 = (ServerComponent)parent.getWizardData("DeployedComponent");
                    try {
                        if (previousPrototype != pair.m_prototype) {
                            Vector<Object> objectsToRemoveList = new Vector<Object>();
                            AssociationList scConnList = serverComponent2.getSourceConnections();
                            for (int connIndex = 0; connIndex < scConnList.size(); ++connIndex) {
                                Connection scConn = (Connection)scConnList.get(connIndex);
                                if (scConn.getId().indexOf(36) == -1) continue;
                                serverComponent2.getSourceConnections().remove((Object)scConn);
                                objectsToRemoveList.add(scConn);
                                AssociationList connPropList = scConn.getProperties();
                                for (int propIndex = 0; propIndex < connPropList.size(); ++propIndex) {
                                    Property prop = (Property)connPropList.get(propIndex);
                                    objectsToRemoveList.add(prop);
                                    PropertyType propType = prop.getOwningType();
                                    if (propType == null) continue;
                                    objectsToRemoveList.add(propType);
                                    TextStore propTypeText = (TextStore)propType.getStoredConfiguration();
                                    if (propTypeText == null) continue;
                                    objectsToRemoveList.add(propTypeText);
                                }
                            }
                            ((MdObjectStore)serverComponent2.getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                            this.m_sasConnection = null;
                            this.m_tcpConnection = null;
                            this.m_comConnection = null;
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
                    }
                    if (pair.m_prototype.getMetadataType().equals("SASClientConnection")) {
                        if (this.m_sasConnection == null) {
                            this.m_sasConnection = (SASClientConnection)Workspace.getMdFactory().createComplexMetadataObject(server.getStore(), null, "SASClientConnection", "SASClientConnection", server.getContext().substring(9), null);
                        }
                        this.m_sasConnection.setUsingPrototype((Root)pair.m_prototype);
                    }
                    if (pair.m_prototype.getMetadataType().equals("TCPIPConnection")) {
                        if (this.m_tcpConnection == null) {
                            this.m_tcpConnection = (TCPIPConnection)Workspace.getMdFactory().createComplexMetadataObject(server.getStore(), null, "TCPIPConnection", "TCPIPConnection", server.getContext().substring(9), null);
                        }
                        this.m_tcpConnection.setUsingPrototype((Root)pair.m_prototype);
                    }
                    if (pair.m_prototype.getMetadataType().equals("COMConnection")) {
                        if (this.m_comConnection == null) {
                            this.m_comConnection = (COMConnection)Workspace.getMdFactory().createComplexMetadataObject(server.getStore(), null, "COMConnection", "COMConnection", server.getContext().substring(9), null);
                        }
                        this.m_comConnection.setUsingPrototype((Root)pair.m_prototype);
                    }
                    try {
                        AssociationList sourceConnectionsList = serverComponent2.getSourceConnections();
                        if (this.m_sasConnection != null) {
                            if (!sourceConnectionsList.contains(this.m_sasConnection)) {
                                if (sourceConnectionsList.size() > 0 && ((Connection)sourceConnectionsList.get(sourceConnectionsList.size() - 1)).getId().indexOf(36) != -1) {
                                    sourceConnectionsList.remove(sourceConnectionsList.size() - 1);
                                }
                                sourceConnectionsList.add(this.m_sasConnection);
                            }
                            parent.replaceWizardData("Connection", (Object)this.m_sasConnection);
                        }
                        if (this.m_tcpConnection != null) {
                            if (!sourceConnectionsList.contains(this.m_tcpConnection)) {
                                if (sourceConnectionsList.size() > 0 && ((Connection)sourceConnectionsList.get(sourceConnectionsList.size() - 1)).getId().indexOf(36) != -1) {
                                    sourceConnectionsList.remove(sourceConnectionsList.size() - 1);
                                }
                                sourceConnectionsList.add(this.m_tcpConnection);
                            }
                            parent.replaceWizardData("Connection", (Object)this.m_tcpConnection);
                        }
                        if (this.m_comConnection != null) {
                            if (!sourceConnectionsList.contains(this.m_comConnection)) {
                                if (sourceConnectionsList.size() > 0 && ((Connection)sourceConnectionsList.get(sourceConnectionsList.size() - 1)).getId().indexOf(36) != -1) {
                                    sourceConnectionsList.remove(sourceConnectionsList.size() - 1);
                                }
                                sourceConnectionsList.add(this.m_comConnection);
                            }
                            parent.replaceWizardData("Connection", (Object)this.m_comConnection);
                        }
                        parent.replaceWizardData("DeployedComponent", (Object)serverComponent2);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
                    }
                    break;
                }
                if ((pTable = (Hashtable)parent.getWizardData("Properties")) != null) {
                    Enumeration e = pTable.keys();
                    while (e.hasMoreElements()) {
                        Object key = e.nextElement();
                        if (!(key instanceof Connection)) continue;
                        Connection ptConn = (Connection)key;
                        Hashtable[] connTableArray = (Hashtable[])pTable.remove(ptConn);
                        pTable.put(parent.getWizardData("Connection"), connTableArray);
                        try {
                            if (ptConn.getSource() == null) {
                                Vector<Connection> objectsToRemoveList = new Vector<Connection>();
                                objectsToRemoveList.add(ptConn);
                                ((MdObjectStore)((Connection)key).getObjectStore()).removeObjectsFromStore(objectsToRemoveList);
                            }
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Deleting");
                        }
                        catch (RemoteException re) {
                            Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
                        }
                        parent.replaceWizardData("Properties", (Object)pTable);
                        break;
                    }
                }
                if (!(serverComponent = (ServerComponent)parent.getWizardData("DeployedComponent")).getClassIdentifier().equals("IOM Spawner")) break block42;
                try {
                    String hostname = "HostName";
                    if (serverComponent.getAssociatedMachine() != null) {
                        Connection connection;
                        Hashtable[] tableArray;
                        String hostvalue = serverComponent.getAssociatedMachine().getName();
                        Hashtable<Connection, Hashtable[]> propertiesTable = (Hashtable<Connection, Hashtable[]>)parent.getWizardData("Properties");
                        if (propertiesTable == null) {
                            propertiesTable = new Hashtable<Connection, Hashtable[]>();
                        }
                        if ((tableArray = (Hashtable[])propertiesTable.get(connection = (Connection)parent.getWizardData("Connection"))) == null) {
                            tableArray = new Hashtable[]{};
                        }
                        boolean replaced = false;
                        for (int index = 0; index < tableArray.length; ++index) {
                            String propname = (String)tableArray[index].get("PropertyName");
                            if (!hostname.equalsIgnoreCase(propname)) continue;
                            tableArray[index].put("DefaultValue", hostvalue);
                            replaced = true;
                        }
                        if (!replaced) {
                            Hashtable<String, String> valueTable = new Hashtable<String, String>();
                            valueTable.put("PropertyName", "HostName");
                            valueTable.put("MetadataType", "Connection");
                            valueTable.put("IsUpdateable", "0");
                            valueTable.put("DefaultValue", hostvalue);
                            Hashtable[] tempTableArray = new Hashtable[tableArray.length + 1];
                            for (int index = 0; index < tableArray.length; ++index) {
                                tempTableArray[index] = tableArray[index];
                            }
                            tempTableArray[tempTableArray.length - 1] = valueTable;
                            propertiesTable.put(connection, tempTableArray);
                        }
                        parent.replaceWizardData("Properties", propertiesTable);
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
                }
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)ex.getLocalizedMessage());
            }
        }
    }

    public void onBack() {
        this.onNext();
    }

    protected boolean _enableMetaServerSASConnectionType(Prototype prototype) throws MdException, RemoteException {
        boolean bEnable = true;
        AssociationList propertiesList = prototype.getPrototypeProperties();
        for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
            AttributeProperty ap;
            PrototypeProperty property = (PrototypeProperty)propertiesList.get(propIndex);
            if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ApplicationProtocol") || !ap.getDefaultValue().equalsIgnoreCase("Bridge") && !ap.getDefaultValue().equalsIgnoreCase("COM")) continue;
            bEnable = false;
            break;
        }
        return bEnable;
    }

    protected boolean _enableTableServerSASConnectionType(Prototype prototype) throws MdException, RemoteException {
        boolean bEnable = true;
        AssociationList propertiesList = prototype.getPrototypeProperties();
        for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
            AttributeProperty ap;
            PrototypeProperty property = (PrototypeProperty)propertiesList.get(propIndex);
            if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ApplicationProtocol") || !ap.getDefaultValue().equalsIgnoreCase("Bridge") && !ap.getDefaultValue().equalsIgnoreCase("COM")) continue;
            bEnable = false;
            break;
        }
        return bEnable;
    }

    protected boolean _enableIOMServerConnectionType(Prototype prototype, LogicalServer logicalServer, List connectionsList) throws MdException, RemoteException {
        Transformation transform;
        boolean bEnable = true;
        String strAppProtocol = "";
        AssociationList propertiesList = prototype.getPrototypeProperties();
        for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
            AttributeProperty ap;
            PrototypeProperty property = (PrototypeProperty)propertiesList.get(propIndex);
            if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ApplicationProtocol")) continue;
            strAppProtocol = ap.getDefaultValue();
            break;
        }
        boolean bContainsCOM = false;
        boolean bContainsBridge = false;
        boolean bContainsMultiBridge = false;
        for (int connIndex = 0; connIndex < connectionsList.size(); ++connIndex) {
            Connection connection = (Connection)connectionsList.get(connIndex);
            String strConnAppProtocol = connection.getApplicationProtocol();
            if (strConnAppProtocol.equals("COM")) {
                bContainsCOM = true;
            }
            if (strConnAppProtocol.equals("Bridge")) {
                bContainsBridge = true;
            }
            if (!strConnAppProtocol.equals("MultiBridge")) continue;
            bContainsMultiBridge = true;
        }
        if (strAppProtocol.equals("COM")) {
            AssociationList initProcessesList;
            if (bEnable && bContainsCOM) {
                bEnable = false;
            }
            if (bEnable && bContainsMultiBridge) {
                bEnable = false;
            }
            if (bEnable && logicalServer != null && (initProcessesList = logicalServer.getInitProcesses()).size() > 0 && (transform = (Transformation)initProcessesList.get(0)).getTransformRole().equals("Load Balancing")) {
                bEnable = false;
            }
        }
        if (strAppProtocol.equals("Bridge") && bEnable && bContainsBridge) {
            bEnable = false;
        }
        if (strAppProtocol.equals("MultiBridge")) {
            if (bEnable && bContainsCOM) {
                bEnable = false;
            }
            if (bEnable && !bContainsBridge) {
                bEnable = false;
            }
            if (bEnable && logicalServer != null) {
                AssociationList initProcessesList = logicalServer.getInitProcesses();
                if (initProcessesList.size() > 0) {
                    transform = (Transformation)initProcessesList.get(0);
                    if (!transform.getTransformRole().equals("Load Balancing")) {
                        bEnable = false;
                    }
                } else {
                    bEnable = false;
                }
            }
        }
        return bEnable;
    }

    protected boolean _enableIOMSpawnerConnectionType(Prototype prototype, List connectionsList) throws MdException, RemoteException {
        boolean bEnable = true;
        String strAppProtocol = "";
        AssociationList propertiesList = prototype.getPrototypeProperties();
        for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
            AttributeProperty ap;
            PrototypeProperty property = (PrototypeProperty)propertiesList.get(propIndex);
            if (!(property instanceof AttributeProperty) || !(ap = (AttributeProperty)property).getPropertyName().equals("ApplicationProtocol")) continue;
            strAppProtocol = ap.getDefaultValue();
            break;
        }
        boolean bContainsOperator = false;
        boolean bContainsUUID = false;
        for (int connIndex = 0; connIndex < connectionsList.size(); ++connIndex) {
            Connection connection = (Connection)connectionsList.get(connIndex);
            String strConnAppProtocol = connection.getApplicationProtocol();
            if (strConnAppProtocol.equals("Operator")) {
                bContainsOperator = true;
            }
            if (!strConnAppProtocol.equals("UUID")) continue;
            bContainsUUID = true;
        }
        if (strAppProtocol.equals("Operator") && bEnable && bContainsOperator) {
            bEnable = false;
        }
        if (strAppProtocol.equals("UUID")) {
            if (bEnable && !bContainsOperator) {
                bEnable = false;
            }
            if (bEnable && bContainsUUID) {
                bEnable = false;
            }
        }
        if (strAppProtocol.equals("PortBank") && bEnable && !bContainsOperator) {
            bEnable = false;
        }
        return bEnable;
    }

    protected void _initialize() {
        this.setName(bundle.getString("PrototypeTypeView.TabName.txt"));
    }

    protected void _layoutWidgets() throws MdException, RemoteException {
        GridBagConstraints gbc;
        Library parentLib;
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        LogicalServer logicalServer = (LogicalServer)parent.getWizardData("LogicalServer");
        ServerComponent serverComponent = (ServerComponent)parent.getWizardData("DeployedComponent");
        Vector realConnectionsList = new Vector();
        AssociationList connectionsList = serverComponent.getSourceConnections();
        realConnectionsList.addAll(connectionsList);
        for (int connIndex = 0; connIndex < realConnectionsList.size(); ++connIndex) {
            Connection conn = (Connection)realConnectionsList.get(connIndex);
            if (conn.getId().indexOf(36) == -1) continue;
            realConnectionsList.remove(connIndex);
            --connIndex;
        }
        boolean bIsMetaServer = false;
        boolean bIsTableServer = false;
        Server server = (Server)parent.getWizardData("Server");
        Component comp = server.getParentComponent();
        if (comp instanceof LibraryWizard) {
            LibraryWizard wizard = (LibraryWizard)((Object)comp);
            parentLib = wizard.m_library;
            if (((SASLibrary)parentLib.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOIME")) {
                bIsMetaServer = true;
            }
            if (((SASLibrary)parentLib.getDeployedDataPackage()).getEngine().equalsIgnoreCase("FEDSVR")) {
                bIsTableServer = true;
            }
        } else if (comp instanceof WAPropertyDialog) {
            WAPropertyDialog propDialog = (WAPropertyDialog)comp;
            if (propDialog.getMetadataObject() instanceof SASLibrary) {
                parentLib = (SASLibrary)propDialog.getMetadataObject();
                if (parentLib.getEngine().equalsIgnoreCase("SASIOIME")) {
                    bIsMetaServer = true;
                }
                if (parentLib.getEngine().equalsIgnoreCase("FEDSVR")) {
                    bIsTableServer = true;
                }
            }
            if (propDialog.getMetadataObject() instanceof DatabaseSchema) {
                DatabaseSchema schema = (DatabaseSchema)propDialog.getMetadataObject();
                try {
                    if (((ServerComponent)schema.getDeployedComponents().get(0)).getClassIdentifier().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
                        bIsMetaServer = true;
                    }
                    if (((ServerComponent)schema.getDeployedComponents().get(0)).getClassIdentifier().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) {
                        bIsTableServer = true;
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)re.getLocalizedMessage());
                }
            }
        }
        boolean bIsIOMServer = false;
        boolean bIsIOMSpawner = serverComponent.getClassIdentifier().equals("IOM Spawner");
        AssociationList serviceTypeList = serverComponent.getServiceTypes();
        for (int typeIndex = 0; typeIndex < serviceTypeList.size(); ++typeIndex) {
            ServiceType serviceType = (ServiceType)serviceTypeList.get(typeIndex);
            if (!serviceType.getName().equals("IOM Server")) continue;
            bIsIOMServer = true;
            break;
        }
        this.setHelpProduct("templatedata");
        this.setHelpTopic("sas_conn_type_generic");
        if (bIsIOMServer) {
            if (serverComponent.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                this.setHelpTopic("sas_conn_type");
            } else if (bIsMetaServer || serverComponent.getClassIdentifier().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
                this.setHelpTopic("sas_conn_type_meta");
            } else if (bIsTableServer || serverComponent.getClassIdentifier().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) {
                this.setHelpTopic("sas_conn_type_tserver");
            } else {
                this.setHelpTopic("sas_conn_type2");
            }
        }
        if (bIsIOMSpawner) {
            this.setHelpTopic("spawn_conn_type");
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_radioPrototypePairList = new Vector();
        for (int i = 0; i < this.m_connectionPrototypeList.size(); ++i) {
            Prototype prototype = (Prototype)this.m_connectionPrototypeList.get(i);
            boolean bEnable = true;
            if (bIsIOMServer) {
                bEnable = this._enableIOMServerConnectionType(prototype, logicalServer, realConnectionsList);
            }
            if (bIsMetaServer) {
                bEnable = this._enableMetaServerSASConnectionType(prototype);
            }
            if (bIsTableServer) {
                bEnable = this._enableTableServerSASConnectionType(prototype);
            }
            if (bIsIOMSpawner) {
                bEnable = this._enableIOMSpawnerConnectionType(prototype, realConnectionsList);
            }
            JRadioButton radio = new JRadioButton(PrototypeUtil.getDisplayString(prototype.getName(), prototype), i == 0);
            radio.setEnabled(bEnable);
            buttonGroup.add(radio);
            this.m_radioPrototypePairList.add(new RadioPrototypePair(radio, prototype));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.anchor = 18;
            gbc.insets = new Insets(0, 0, 12, 0);
            gridBagLayout.setConstraints(radio, gbc);
            this.add(radio);
            WATextArea text = new WATextArea(PrototypeUtil.getDisplayString(prototype.getDesc(), prototype));
            text.setEnabled(bEnable);
            text.setEditable(false);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setBorder(null);
            text.setBackground(this.getBackground());
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 5, 12, 0);
            gridBagLayout.setConstraints((Component)text, gbc);
            this.add((Component)text);
        }
        for (int pairIndex = 0; pairIndex < this.m_radioPrototypePairList.size(); ++pairIndex) {
            RadioPrototypePair pair = (RadioPrototypePair)this.m_radioPrototypePairList.get(pairIndex);
            JRadioButton radio = pair.m_radio;
            if (!radio.isEnabled()) continue;
            radio.setSelected(true);
            break;
        }
        block7: for (int connIndex = 0; connIndex < connectionsList.size(); ++connIndex) {
            Connection conn = (Connection)connectionsList.get(connIndex);
            if (conn.getId().indexOf(36) == -1) continue;
            Prototype connPrototype = (Prototype)conn.getUsingPrototype();
            for (int pairIndex = 0; pairIndex < this.m_radioPrototypePairList.size(); ++pairIndex) {
                RadioPrototypePair pair = (RadioPrototypePair)this.m_radioPrototypePairList.get(pairIndex);
                JRadioButton radio = pair.m_radio;
                if (!radio.isEnabled() || connPrototype != pair.m_prototype) continue;
                radio.setSelected(true);
                continue block7;
            }
        }
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    protected class RadioPrototypePair {
        public JRadioButton m_radio;
        public Prototype m_prototype;

        public RadioPrototypePair(JRadioButton radio, Prototype prototype) {
            this.m_radio = radio;
            this.m_prototype = prototype;
        }
    }
}

