/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.TitledSeparator;
import com.sas.workspace.visuals.ToggleButtonPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class CommandsPropertyView
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected Server m_server;
    protected int m_type;
    protected WATextArea m_titleText;
    protected ToggleButtonPanel m_definePanel;
    protected JCheckBox m_defineCheckBox;
    protected JLabel m_stmtLabel;
    protected JTextField m_stmtText;
    protected JCheckBox m_multipleCheckBox;
    protected TitledSeparator m_titledSeparator;
    protected JLabel m_usernameLabel;
    protected JTextField m_usernameText;
    private static final WAdminResource bundle = WAdminResource.getBundle(CommandsPropertyView.class);

    public CommandsPropertyView(Server server, int type) {
        this.m_server = server;
        this.m_type = type;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            if (this.m_type == 1) {
                this._setViewProperties();
            }
        } else {
            if (this.m_type == 1) {
                try {
                    AssociationList propertiesList = this.m_server.getDeployedComponent().getProperties();
                    block3: for (int i = 0; i < propertiesList.size(); ++i) {
                        Property property = (Property)propertiesList.get(i);
                        if (property.getPropertyName().equals("Command")) {
                            this.m_stmtText.setText(property.getDefaultValue());
                        }
                        if (!property.getPropertyName().equals("IsMultiUser")) continue;
                        this.m_multipleCheckBox.setSelected(property.getDefaultValue().equals("1"));
                        AssociationList initProcessesList = this.m_server.getDeployedComponent().getInitProcesses();
                        for (int j = 0; j < initProcessesList.size(); ++j) {
                            AbstractTransformation abstractTransform = (AbstractTransformation)initProcessesList.get(j);
                            if (!(abstractTransform instanceof Transformation)) continue;
                            Transformation transform = (Transformation)abstractTransform;
                            AssociationList sourcesList = transform.getTransformationSources();
                            for (int k = 0; k < sourcesList.size(); ++k) {
                                Root root = (Root)sourcesList.get(k);
                                if (!(root instanceof Login)) continue;
                                Login login = (Login)root;
                                this.m_usernameText.setText(login.getName());
                                continue block3;
                            }
                            continue block3;
                        }
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
            this.m_definePanel.setState();
            this.onMultipleSelected();
        }
        return false;
    }

    public boolean validateData() {
        return true;
    }

    public void onDefineStartup() {
        this.onMultipleSelected();
        if (!this.m_multipleCheckBox.isEnabled()) {
            this.m_titledSeparator.setEnabled(false);
            this.m_usernameLabel.setEnabled(false);
            this.m_usernameText.setEnabled(false);
        }
    }

    public void onMultipleSelected() {
        if (this.m_multipleCheckBox.isSelected() && this.m_multipleCheckBox.isEnabled()) {
            this.m_titledSeparator.setEnabled(true);
            this.m_usernameLabel.setEnabled(true);
            this.m_usernameText.setEnabled(true);
        } else {
            this.m_titledSeparator.setEnabled(false);
            this.m_usernameLabel.setEnabled(false);
            this.m_usernameText.setEnabled(false);
        }
    }

    protected void _setViewProperties() {
        try {
            AssociationList propertyList = this.m_server.getDeployedComponent().getProperties();
            String strCommand = this.m_stmtText.getText();
            if (strCommand != null && !strCommand.equals("")) {
                boolean bCommandPropertyFound = false;
                for (int i = 0; i < propertyList.size(); ++i) {
                    Property dcProperty = (Property)propertyList.get(i);
                    if (!dcProperty.getPropertyName().equalsIgnoreCase("Command")) continue;
                    dcProperty.setDefaultValue(strCommand, 1);
                    bCommandPropertyFound = true;
                    break;
                }
                if (!bCommandPropertyFound) {
                    Property commandProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, "Command", "Property", this.m_server.getContext().substring(9));
                    commandProperty.setPropertyName("Command", 1);
                    commandProperty.setDefaultValue(strCommand, 1);
                    commandProperty.setAssociatedObject((Root)this.m_server.getDeployedComponent());
                    PropertyType commandType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, "String", "PropertyType", this.m_server.getContext().substring(9));
                    commandProperty.setOwningType(commandType);
                    this.m_server.getDeployedComponent().getProperties().add((Object)commandProperty);
                }
            }
            boolean bIsMultiUser = this.m_multipleCheckBox.isSelected();
            boolean bMultiuserPropertyFound = false;
            for (int i = 0; i < propertyList.size(); ++i) {
                Property dcProperty = (Property)propertyList.get(i);
                if (!dcProperty.getPropertyName().equalsIgnoreCase("IsMultiUser")) continue;
                dcProperty.setDefaultValue(bIsMultiUser ? "1" : "0", 1);
                bMultiuserPropertyFound = true;
                break;
            }
            if (!bMultiuserPropertyFound) {
                Property multiUserProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, "IsMultiUser", "Property", this.m_server.getContext().substring(9));
                multiUserProperty.setPropertyName("IsMultiUser", 1);
                multiUserProperty.setDefaultValue(bIsMultiUser ? "1" : "0", 1);
                multiUserProperty.setAssociatedObject((Root)this.m_server.getDeployedComponent());
                PropertyType multiUserType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, "String", "PropertyType", this.m_server.getContext().substring(9));
                multiUserProperty.setOwningType(multiUserType);
                this.m_server.getDeployedComponent().getProperties().add((Object)multiUserProperty);
            }
            if (bIsMultiUser) {
                Transformation transform = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, "Transformation", "Transformation", this.m_server.getContext().substring(9));
                Login login = (Login)Workspace.getMdFactory().createComplexMetadataObject(this.m_server.getStore(), null, "Login", "Login", this.m_server.getContext().substring(9));
                login.setName(this.m_usernameText.getText(), 1);
                transform.getTransformationSources().add((Object)login);
                this.m_server.getDeployedComponent().getInitProcesses().add((Object)transform);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onNext() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        try {
            this._setViewProperties();
            boolean bShowServiceTypes = false;
            Prototype deployedComponentPrototype = (Prototype)parent.getWizardData("DeployedComponentPrototype");
            AssociationList associationsList = deployedComponentPrototype.getAssociations();
            for (int i = 0; i < associationsList.size(); ++i) {
                AssociationProperty property = (AssociationProperty)associationsList.get(i);
                if (!property.getAssociationName().equals("ServiceTypes")) continue;
                bShowServiceTypes = true;
                break;
            }
            if (bShowServiceTypes) {
                this.setConditionState("SERVICETYPE");
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    public void onBack() {
        try {
            AssociationList propertiesList = this.m_server.getDeployedComponent().getProperties();
            for (int i = 0; i < propertiesList.size(); ++i) {
                Property property = (Property)propertiesList.get(i);
                if (property.getPropertyName().equals("Command")) {
                    try {
                        this.m_server.getDeployedComponent().getProperties().remove((Object)property);
                        i = 0;
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        continue;
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                    }
                }
                if (!property.getPropertyName().equals("IsMultiUser")) continue;
                try {
                    this.m_server.getDeployedComponent().getProperties().remove((Object)property);
                    i = 0;
                    continue;
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
                }
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    protected void _initialize() {
        this.setName(bundle.getString("CommandsPropertyView.TabName.txt"));
        if (this.m_type == 0) {
            this.m_titleText = new WATextArea(bundle.getString("CommandsPropertyView.WizardTitle.txt"));
            this.m_titleText.setEditable(false);
            this.m_titleText.setLineWrap(true);
            this.m_titleText.setWrapStyleWord(true);
            this.m_titleText.setBorder(null);
            this.m_titleText.setBackground(this.getBackground());
        }
        this.m_defineCheckBox = new JCheckBox();
        this.m_defineCheckBox.setSelected(false);
        this.m_defineCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandsPropertyView.this.onDefineStartup();
            }
        });
        this.m_definePanel = new ToggleButtonPanel(bundle.getString("CommandsPropertyView.DefineStartup.txt"), (JToggleButton)this.m_defineCheckBox);
        this.m_stmtLabel = new JLabel(bundle.getString("CommandsPropertyView.Statement.txt"));
        this.m_stmtText = new JTextField();
        this.m_multipleCheckBox = new JCheckBox(bundle.getString("CommandsPropertyView.MultipleUsers.txt"));
        this.m_multipleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandsPropertyView.this.onMultipleSelected();
            }
        });
        this.m_titledSeparator = new TitledSeparator(bundle.getString("CommandsPropertyView.Login.txt"));
        this.m_usernameLabel = new JLabel(bundle.getString("CommandsPropertyView.UserName.txt"));
        this.m_usernameText = new JTextField();
    }

    protected void _layoutWidgets() {
        GridBagConstraints gbc;
        this._layoutInteriorPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        if (this.m_type == 0) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(12, 12, 0, 12);
            gridBagLayout.setConstraints((Component)this.m_titleText, gbc);
            this.add((Component)this.m_titleText);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_definePanel, gbc);
        this.add((Component)this.m_definePanel);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }

    protected void _layoutInteriorPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel panel = new JPanel();
        panel.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_stmtLabel, gbc);
        panel.add(this.m_stmtLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_stmtText, gbc);
        panel.add(this.m_stmtText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_multipleCheckBox, gbc);
        panel.add(this.m_multipleCheckBox);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_titledSeparator, gbc);
        panel.add(this.m_titledSeparator);
        JPanel userPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        userPanel.setLayout(gbl);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 0);
        gbl.setConstraints(this.m_usernameLabel, gbc);
        userPanel.add(this.m_usernameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gbl.setConstraints(this.m_usernameText, gbc);
        userPanel.add(this.m_usernameText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gridBagLayout.setConstraints(userPanel, gbc);
        panel.add(userPanel);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        panel.add(eaterPanel);
        this.m_definePanel.getInteriorPanel().add(panel);
    }
}

