/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Repository;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.mgmt.visuals.AddAuthDomainTableAction;
import com.sas.workspace.mgmt.visuals.AuthenticationDomainsTableModel;
import com.sas.workspace.mgmt.visuals.EditAuthDomainTableAction;
import com.sas.workspace.mgmt.visuals.RmvAuthDomainTableAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.omg.CORBA.Object;

public class AuthenticationDomainsEditorTab
extends WAPropertyTab
implements ListSelectionListener,
WsPopupMenuRequestListener {
    private static final long serialVersionUID = 1L;
    protected GridBagLayout m_gridBagLayout = new GridBagLayout();
    protected JButton m_newDomainButton;
    protected JButton m_removeDomainButton;
    protected JButton m_modifyDomainButton;
    protected ISecurity_1_1 m_iSecurity = null;
    protected JPopupMenu m_popupMenu;
    protected MouseListener m_tableMouseListner;
    protected String m_reposid = null;
    protected WsTable m_authenticationDomainsTable = null;
    protected AuthenticationDomainsTableModel m_tableModel = null;
    protected Action m_addAction;
    protected Action m_modifyAction;
    protected Action m_removeAction;
    private MdObjectStore m_objectStore;
    private static final WAdminResource bundle = new WAdminResource(AuthenticationDomainsEditorTab.class);

    public AuthenticationDomainsEditorTab(MdObjectStore objectStore, String reposID) {
        this.m_objectStore = objectStore;
        this.m_reposid = reposID;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.setHelpProduct("templatedata");
        this.setHelpTopic("auth_domain_mgmt");
        this.setName(bundle.getString("AuthenticationDomainsEditorTab.Title.txt"));
        IOMI iOmi = Workspace.getWorkspace().getCMRHandle();
        if (iOmi != null) {
            try {
                this.m_iSecurity = ISecurity_1_1Helper.narrow((Object)Workspace.getMdFactory().getConnection().getCMRHandle());
            }
            catch (Exception e) {
                String errMsg = e.getMessage() == null || e.getMessage().length() == 0 ? bundle.getString("AuthenticationDomainsEditorTab.Error.txt") : e.getMessage();
                MessageUtil.displayMessage((String)errMsg, (int)0, (int)-1);
            }
        } else {
            String errMsg = bundle.getString("AuthenticationDomainsEditorTab.Error.txt");
            MessageUtil.displayMessage((String)errMsg, (int)0, (int)-1);
        }
        this.m_tableModel = new AuthenticationDomainsTableModel(this.m_reposid, this.m_objectStore);
        this.m_authenticationDomainsTable = new MyTable(this.m_tableModel);
        this.m_authenticationDomainsTable.setAutoResizeMode(3);
        this.m_authenticationDomainsTable.setRowHeaderVisible(false);
        this.m_authenticationDomainsTable.setCellSelectionEnabled(false);
        this.m_authenticationDomainsTable.setRowSelectionAllowed(true);
        this.m_tableMouseListner = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!AuthenticationDomainsEditorTab.this.isEditable()) {
                    return;
                }
                int row = AuthenticationDomainsEditorTab.this.m_authenticationDomainsTable.rowAtPoint(e.getPoint());
                if (e.getClickCount() >= 2) {
                    if (row != -1) {
                        AuthenticationDomainsEditorTab.this.m_modifyDomainButton.doClick();
                    } else {
                        AuthenticationDomainsEditorTab.this.m_authenticationDomainsTable.getSelectionModel().clearSelection();
                        AuthenticationDomainsEditorTab.this.m_newDomainButton.doClick();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AuthenticationDomainsEditorTab.this.updateButtonStates();
            }
        };
        this.m_authenticationDomainsTable.addMouseListener(this.m_tableMouseListner);
        this.m_authenticationDomainsTable.setTablePopupMenuEnabled(true);
        this.m_authenticationDomainsTable.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)this);
        this.m_authenticationDomainsTable.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)this);
        this.m_authenticationDomainsTable.addKeyListener((KeyListener)new TableKeyListener());
        this.m_authenticationDomainsTable.getSelectionModel().addListSelectionListener(this);
        this.m_tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AuthenticationDomainsEditorTab.this.setDataChanged(true);
            }
        });
        this.m_addAction = new AddAuthDomainTableAction(this.m_objectStore, this.m_reposid, this.m_authenticationDomainsTable);
        this.m_modifyAction = new EditAuthDomainTableAction(this.m_reposid, this.m_authenticationDomainsTable);
        this.m_removeAction = new RmvAuthDomainTableAction(this.m_authenticationDomainsTable, this.m_iSecurity);
        this.m_popupMenu = new JPopupMenu();
        this.m_popupMenu.add(this.m_addAction).setToolTipText(null);
        this.m_popupMenu.add(this.m_modifyAction).setToolTipText(null);
        this.m_popupMenu.add(this.m_removeAction).setToolTipText(null);
        this.m_newDomainButton = new JButton(this.m_addAction);
        this.m_modifyDomainButton = new JButton(this.m_modifyAction);
        this.m_removeDomainButton = new JButton(this.m_removeAction);
        int maxWidth = Math.max(this.m_newDomainButton.getPreferredSize().width, this.m_modifyDomainButton.getPreferredSize().width);
        maxWidth = Math.max(maxWidth, this.m_removeDomainButton.getPreferredSize().width);
        this.m_newDomainButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.m_newDomainButton.setPreferredSize(new Dimension(maxWidth, 25));
        this.m_modifyDomainButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.m_modifyDomainButton.setPreferredSize(new Dimension(maxWidth, 25));
        this.m_removeDomainButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.m_removeDomainButton.setPreferredSize(new Dimension(maxWidth, 25));
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout(5, 5));
        String strTitle = bundle.getString("AuthenticationDomainsEditorTab.Title.txt");
        topPanel.setBorder(BorderFactory.createTitledBorder(strTitle));
        Insets bttnInsets = new Insets(5, 0, 0, 0);
        JScrollPane scrollPane = new JScrollPane((Component)this.m_authenticationDomainsTable);
        scrollPane.addMouseListener(this.m_tableMouseListner);
        scrollPane.getViewport().setBackground(this.m_authenticationDomainsTable.getBackground());
        topPanel.add((Component)scrollPane, "Center");
        JPanel rightButtonPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.m_newDomainButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, bttnInsets, 0, 0));
        buttonPanel.add((Component)this.m_modifyDomainButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, bttnInsets, 0, 0));
        buttonPanel.add((Component)this.m_removeDomainButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, bttnInsets, 0, 0));
        rightButtonPanel.add((Component)buttonPanel, "North");
        topPanel.add((Component)rightButtonPanel, "East");
        this.add(topPanel, "Center");
    }

    public boolean validateData() {
        return true;
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            try {
                List rmvdItems = this.m_tableModel.getRmvdTableItems();
                for (int i = 0; i < rmvdItems.size(); ++i) {
                    AuthenticationDomain domain = (AuthenticationDomain)rmvdItems.get(i);
                    AssociationList logins = domain.getLogins(true);
                    for (int j = 0; j < logins.size(); ++j) {
                        this.m_objectStore.deleteObject((CMetadata)logins.get(j));
                    }
                    this.m_objectStore.deleteObject((CMetadata)domain);
                }
                this.m_tableModel.clearRmvdTableItems();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
            }
        } else {
            try {
                this.refresh();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void refresh() throws MdException, RemoteException {
        this.m_tableModel.refreshModelData();
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (!editable) {
            this.m_newDomainButton.setEnabled(editable);
            this.m_modifyDomainButton.setEnabled(editable);
            this.m_removeDomainButton.setEnabled(editable);
        } else {
            this.updateButtonStates();
        }
        this.m_authenticationDomainsTable.setEditable(editable);
        this.m_authenticationDomainsTable.setEnabled(editable);
        boolean isProjectRepos = AuthenticationDomainsEditorTab.isProjectRepository(this.m_reposid);
        if (isProjectRepos) {
            this.m_newDomainButton.setEnabled(false);
        }
    }

    public static boolean isProjectRepository(String reposID) {
        if (reposID == null) {
            return false;
        }
        Repository[] allRepositoriesArray = AuthenticationDomainsEditorTab.getRepositories();
        for (int i = 0; i < allRepositoriesArray.length; ++i) {
            if (!allRepositoriesArray[i].getFQID().equalsIgnoreCase(reposID) || !allRepositoriesArray[i].getType().equalsIgnoreCase("Project")) continue;
            return true;
        }
        return false;
    }

    public static Repository[] getRepositories() {
        try {
            return Repository.getRepositories((IOMI)Workspace.getWorkspace().getCMRHandle());
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getMessage());
            return new Repository[0];
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.updateButtonStates();
    }

    public void popupMenuRequested(MouseEvent e) {
        this.updateButtonStates();
        this.m_popupMenu.show((Component)this.m_authenticationDomainsTable, e.getX(), e.getY());
    }

    protected void updateButtonStates() {
        this.m_addAction.setEnabled(true);
        this.m_removeAction.setEnabled(this.m_authenticationDomainsTable.getSelectedRowCount() >= 1);
        this.m_modifyAction.setEnabled(this.m_authenticationDomainsTable.getSelectedRowCount() == 1);
    }

    public List getDomainList() {
        return this.m_tableModel.getDomainList();
    }

    protected void finalize() throws Throwable {
        if (this.m_iSecurity != null) {
            Workspace.getMdFactory().getConnection().closeISecurityConnection((ISecurity)this.m_iSecurity);
        }
        super.finalize();
    }

    class MyTable
    extends WsTable {
        public MyTable(WsAbstractTableModel mdl) {
            super(mdl);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer renderer = super.getCellRenderer(row, column);
            if (renderer instanceof JLabel && column > 1) {
                ((JLabel)((java.lang.Object)renderer)).setHorizontalAlignment(0);
            }
            return renderer;
        }
    }

    class TableKeyListener
    extends KeyAdapter {
        TableKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            AuthenticationDomainsEditorTab.this.updateButtonStates();
        }
    }
}

