/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt.visuals;

import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.mgmt.visuals.ConnectionsPropertyView;
import com.sas.workspace.mgmt.visuals.Server;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AddAdditionalConnectionPropertyView
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected WATextArea m_addConnectionText;
    protected JCheckBox m_addConnectionCheckBox;
    protected Server m_server;
    protected int m_numAddition = 0;
    private static final WAdminResource bundle = WAdminResource.getBundle(AddAdditionalConnectionPropertyView.class);

    public AddAdditionalConnectionPropertyView(Server server) {
        this.m_server = server;
        this._initialize();
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.m_addConnectionCheckBox.setEnabled(false);
        }
        return false;
    }

    public boolean validateData() {
        return true;
    }

    public void onNext() {
    }

    public void onBack() {
    }

    public void onAddConnection() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        ++this.m_numAddition;
        if (this.m_addConnectionCheckBox.isSelected()) {
            String strTransition = "AdditionalConnection" + String.valueOf(this.m_numAddition);
            parent.addTab(bundle.getString("ServerWizard.Title.txt"), strTransition, (WAPropertyTab)new ConnectionsPropertyView(this.m_server, 0));
            String[][] transition = new String[][]{{"AddAdditionalConnection", "ADDCONNECTION", strTransition}};
            ((WATransitionWizardModel)parent.getWizardModel()).addTransitions(transition);
            this.setConditionState("ADDCONNECTION");
        } else {
            this.setConditionState("NEXT");
        }
    }

    protected void _initialize() {
        this.setName(bundle.getString("AddAdditionalConnectionView.TabName.txt"));
        this.m_addConnectionText = new WATextArea(bundle.getString("AddAdditionalConnectionView.AddConnection.txt"));
        this.m_addConnectionText.setEditable(false);
        this.m_addConnectionText.setLineWrap(true);
        this.m_addConnectionText.setWrapStyleWord(true);
        this.m_addConnectionText.setBorder(null);
        this.m_addConnectionText.setBackground(this.getBackground());
        this.m_addConnectionCheckBox = new JCheckBox(bundle.getString("AddAdditionalConnectionView.AddNewConnection.txt"));
        this.m_addConnectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddAdditionalConnectionPropertyView.this.onAddConnection();
            }
        });
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints((Component)this.m_addConnectionText, gbc);
        this.add((Component)this.m_addConnectionText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 17;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_addConnectionCheckBox, gbc);
        this.add(this.m_addConnectionCheckBox);
        JPanel eaterPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(12, 12, 12, 12);
        gridBagLayout.setConstraints(eaterPanel, gbc);
        this.add(eaterPanel);
    }
}

