/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt;

import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.MetadataObjectCellRenderer;
import java.rmi.RemoteException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class SortUtil {
    public static List sortAscending(List contentList) {
        CollationKey[] keys = SortUtil.convertToCollatorKeys(contentList);
        if (keys == null) {
            return null;
        }
        for (int i = 0; i < keys.length; ++i) {
            for (int j = i + 1; j < keys.length; ++j) {
                if (keys[i].compareTo(keys[j]) <= 0) continue;
                CollationKey temp = keys[i];
                keys[i] = keys[j];
                keys[j] = temp;
            }
        }
        return SortUtil.getSortedList(contentList, keys);
    }

    protected static List getSortedList(List contentList, CollationKey[] keys) {
        Vector<Object> sortedList = new Vector<Object>(1);
        try {
            for (int i = 0; i < keys.length; ++i) {
                String name = keys[i].getSourceString();
                Object contentItem = null;
                for (int j = 0; j < contentList.size(); ++j) {
                    Object currentItem = contentList.get(j);
                    if (currentItem instanceof PhysicalTable) {
                        if (!((PhysicalTable)currentItem).getName().equalsIgnoreCase(name)) continue;
                        contentItem = currentItem;
                        contentList.remove(contentItem);
                        break;
                    }
                    if (currentItem instanceof SASLibrary) {
                        if (!((SASLibrary)currentItem).getName().equalsIgnoreCase(name)) continue;
                        contentItem = currentItem;
                        contentList.remove(contentItem);
                        break;
                    }
                    if (currentItem instanceof DatabaseSchema) {
                        if (!((DatabaseSchema)currentItem).getName().equalsIgnoreCase(name)) continue;
                        contentItem = currentItem;
                        contentList.remove(contentItem);
                        break;
                    }
                    if (currentItem instanceof Login) {
                        if (!((Login)currentItem).getUserID().equalsIgnoreCase(name)) continue;
                        contentItem = currentItem;
                        contentList.remove(contentItem);
                        break;
                    }
                    if (!(currentItem instanceof Directory) || !MetadataObjectCellRenderer.getDisplayName((Root)((Directory)currentItem)).equalsIgnoreCase(name)) continue;
                    contentItem = currentItem;
                    contentList.remove(contentItem);
                    break;
                }
                if (contentItem == null) continue;
                sortedList.add(i, contentItem);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return sortedList;
    }

    protected static CollationKey[] convertToCollatorKeys(List contentList) {
        try {
            Collator collator = Collator.getInstance(Locale.getDefault());
            collator.setStrength(2);
            CollationKey[] keys = new CollationKey[contentList.size()];
            boolean itemNotRecognized = false;
            for (int i = 0; i < contentList.size(); ++i) {
                Object contentItem = contentList.get(i);
                if (contentItem instanceof PhysicalTable) {
                    keys[i] = collator.getCollationKey(((PhysicalTable)contentItem).getName());
                    continue;
                }
                if (contentItem instanceof SASLibrary) {
                    keys[i] = collator.getCollationKey(((SASLibrary)contentItem).getName());
                    continue;
                }
                if (contentItem instanceof DatabaseSchema) {
                    keys[i] = collator.getCollationKey(((DatabaseSchema)contentItem).getName());
                    continue;
                }
                if (contentItem instanceof Login) {
                    keys[i] = collator.getCollationKey(((Login)contentItem).getUserID());
                    continue;
                }
                if (contentItem instanceof Directory) {
                    keys[i] = collator.getCollationKey(MetadataObjectCellRenderer.getDisplayName((Root)((Directory)contentItem)));
                    continue;
                }
                itemNotRecognized = true;
            }
            if (itemNotRecognized) {
                return null;
            }
            return keys;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }
}

