/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt;

import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class ProjectRepository {
    private static WAdminResource bundle = WAdminResource.getBundle(ProjectRepository.class);
    protected Repository m_repos;
    protected String m_strFQID;

    public ProjectRepository(Repository rep) {
        if (!rep.isProject()) {
            throw new IllegalArgumentException(bundle.getString("ProjectRepository.IllegalType.txt"));
        }
        this.m_repos = rep;
        this.m_strFQID = rep.getId();
    }

    public Repository getRepository() {
        return this.m_repos;
    }

    public boolean checkedOutObjectsExist() throws MdException, RemoteException {
        List resultList = null;
        String strSelect = "<XMLSELECT search=\"@Name?'SavedPrimaryState'\"/>";
        int flags = 2176;
        try {
            resultList = Workspace.getMdFactory().getOMIUtil().getMetadataObjects(this.m_strFQID, "TextStore", flags, strSelect);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        if (resultList != null && resultList.size() > 0) {
            return true;
        }
        String strReposId = this.m_strFQID.substring(9, 17);
        strSelect = "<XMLSELECT search=\"@ChangeState?'" + strReposId + "'\"/>";
        flags = 10384;
        try {
            resultList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsNoCache("Root", this.m_strFQID, strSelect, flags);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        if (resultList == null || resultList.size() == 0) {
            return false;
        }
        resultList.clear();
        resultList = null;
        return true;
    }

    public void cleanupCheckouts() throws MdException, RemoteException {
        StringBuffer inXMLBuffer = new StringBuffer("<UndoCheckoutLogical>");
        inXMLBuffer.append(" <Metadata/>");
        inXMLBuffer.append(" <ProjectReposId>" + this.m_strFQID + "</ProjectReposId>");
        inXMLBuffer.append(" <ns>SAS</ns>");
        inXMLBuffer.append(" <flags>1</flags>");
        inXMLBuffer.append(" <Options/>");
        inXMLBuffer.append("</UndoCheckoutLogical>");
        String strXML = inXMLBuffer.toString();
        try {
            Workspace.getMdFactory().getOMIUtil().DoRequest(strXML, false);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }
}

