/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.util.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class MetadataServerUtil {
    private static final String LOCALHOST = "localhost";
    private static final String LOCALHOSTIPV4 = "127.0.0.1";
    private static final String LOCALHOSTIPV6 = "::1";

    public static ServerContext getDefaultServerContext(MdFactory m_Factory, MdObjectStore m_store) throws RemoteException {
        ServerContext serverContext = null;
        serverContext = MetadataServerUtil.getServerContext(m_Factory, m_store, null, null);
        return serverContext;
    }

    public static ServerContext getServerContext(MdFactory m_Factory, MdObjectStore m_store, String reposID, Properties cmrProperties) throws RemoteException {
        ServerContext serverContext = null;
        String template = new String("<TEMPLATES><ServerContext Id=\"\" Name=\"\"><UsingComponents/></ServerContext><LogicalServer Id=\"\" Name=\"\" ClassIdentifier=\"\"/></TEMPLATES>");
        String select = new String("<XMLSELECT search=\"*[UsingComponents/LogicalServer[@ClassIdentifier='0217E202-B560-11DB-AD91-001083FF6836']]\"/>");
        String options = template + select;
        int flags = 396;
        try {
            String currentPort;
            String currentHost;
            if (cmrProperties == null) {
                Properties p = m_Factory.getConnection().getCMRProperties();
                currentHost = p.getProperty("host");
                currentPort = p.getProperty("port");
            } else {
                currentHost = cmrProperties.getProperty("host");
                currentPort = cmrProperties.getProperty("port");
            }
            List objects = MetadataServerUtil.retrieveObjects(m_Factory, (MdStore)m_store, reposID, "ServerContext", flags, options);
            for (int i = 0; i < objects.size(); ++i) {
                ServerContext sc = (ServerContext)objects.get(i);
                AssociationList logicalServers = sc.getUsingComponents();
                boolean found = false;
                for (int j = 0; j < logicalServers.size() && !found; ++j) {
                    LogicalServer ls = (LogicalServer)logicalServers.get(j);
                    if (!ls.getClassIdentifier().equals("440196D4-90F0-11D0-9F41-00A024BB830C")) continue;
                    ServerComponent serverComponent = MetadataServerUtil.getMetadataServerFromServerContext(m_Factory, sc);
                    TCPIPConnection connection = MetadataServerUtil.getConnectionFromServerComponent(serverComponent);
                    int port = connection.getPort();
                    Integer port2 = new Integer(port);
                    String strPort = port2.toString();
                    String host = connection.getHostName();
                    if (!MetadataServerUtil.isPortsEqual(currentPort, strPort) || !MetadataServerUtil.isHostsEqual(currentHost, host)) continue;
                    serverContext = sc;
                    found = true;
                }
                if (!found) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            m_Factory.getUtil().printOutputln(e.getMessage());
        }
        return serverContext;
    }

    public static ServerComponent getMetadataServerFromServerContext(MdFactory m_Factory, ServerContext server) throws MdException, RemoteException {
        ServerComponent sc = null;
        try {
            AssociationList logicalServers = server.getUsingComponents();
            for (int i = 0; i < logicalServers.size(); ++i) {
                LogicalServer ls = (LogicalServer)logicalServers.get(i);
                if (!ls.getClassIdentifier().equals("0217E202-B560-11DB-AD91-001083FF6836")) continue;
                AssociationList serverComponents = ls.getUsingComponents();
                sc = (ServerComponent)serverComponents.get(0);
                break;
            }
        }
        catch (MdException e) {
            m_Factory.getUtil().printOutputln("Getting MetadataServer from Server Context" + server.getName() + "  " + server.getFQID() + ":\n" + e.getMessage());
            throw e;
        }
        catch (RemoteException re) {
            throw re;
        }
        return sc;
    }

    public static TCPIPConnection getConnectionFromServerComponent(ServerComponent serverComponent) throws MdException, RemoteException {
        TCPIPConnection connection = null;
        try {
            AssociationList connections = serverComponent.getSourceConnections(true);
            for (int index = 0; index < connections.size(); ++index) {
                if (!(connections.get(index) instanceof TCPIPConnection)) continue;
                connection = (TCPIPConnection)connections.get(index);
                break;
            }
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException re) {
            throw re;
        }
        return connection;
    }

    public static LogicalServer getLogicalMetadataServerFromServerContext(MdFactory m_Factory, ServerContext server) throws MdException, RemoteException {
        LogicalServer ls = null;
        try {
            AssociationList logicalServers = server.getUsingComponents();
            for (int i = 0; i < logicalServers.size(); ++i) {
                LogicalServer logServer = (LogicalServer)logicalServers.get(i);
                if (!logServer.getClassIdentifier().equals("0217E202-B560-11DB-AD91-001083FF6836")) continue;
                ls = logServer;
                break;
            }
        }
        catch (MdException e) {
            m_Factory.getUtil().printOutputln("Getting Logical MetadataServer from Server Context" + server.getName() + "  " + server.getFQID() + ":\n" + e.getMessage());
            throw e;
        }
        catch (RemoteException re) {
            throw re;
        }
        return ls;
    }

    public static boolean isHostsEqual(String host1, String host2) throws UnknownHostException {
        boolean result = false;
        if (host1 == null || host2 == null) {
            return false;
        }
        if (host1.equalsIgnoreCase(host2)) {
            return true;
        }
        String ipHostAddress1 = null;
        String ipHostAddress2 = null;
        ipHostAddress1 = MetadataServerUtil.convertToIPAddress(host1);
        ipHostAddress2 = MetadataServerUtil.convertToIPAddress(host2);
        if (ipHostAddress1 != null && ipHostAddress2 != null) {
            result = ipHostAddress1.equals(ipHostAddress2);
        }
        return result;
    }

    public static boolean isPortsEqual(String port1, String port2) {
        boolean result = false;
        if (port1 == null || port2 == null) {
            return false;
        }
        if (port1.equalsIgnoreCase(port2)) {
            return true;
        }
        return result;
    }

    public static String convertToIPAddress(String host) throws UnknownHostException {
        String ipHostAddress = null;
        if (!MetadataServerUtil.isEmpty(host)) {
            boolean islocalHost = Strings.equal((String)host, (String)LOCALHOST, (boolean)false, (boolean)true);
            boolean islocalHostIPv4 = Strings.equal((String)host, (String)LOCALHOSTIPV4, (boolean)false, (boolean)true);
            boolean islocalHostIPv6 = Strings.equal((String)host, (String)LOCALHOSTIPV6, (boolean)false, (boolean)true);
            InetAddress address = islocalHost || islocalHostIPv4 || islocalHostIPv6 ? InetAddress.getLocalHost() : InetAddress.getByName(host);
            ipHostAddress = address.getHostAddress();
        }
        return ipHostAddress;
    }

    public static boolean isEmpty(String str) {
        boolean isEmpty = false;
        if (str == null) {
            isEmpty = true;
        } else if (str.length() <= 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public static String determineMSdirectoryName(MdFactory m_Factory, LogicalServer m_logicalServer) throws RemoteException {
        String configMetadataServerdirectory = "MetadataServer";
        if (m_logicalServer != null) {
            HashMap m_publicProps = new HashMap();
            HashMap m_privateProps = new HashMap();
            try {
                ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)m_logicalServer, m_publicProps, m_privateProps);
            }
            catch (MdException e) {
                m_Factory.getUtil().printOutputln(e.getMessage());
            }
            catch (RemoteException re) {
                throw re;
            }
            if (m_privateProps != null && m_privateProps.size() > 0) {
                Set ks = m_privateProps.keySet();
                for (String propName : ks) {
                    if (!propName.equalsIgnoreCase("iomsrv.metadatasrv.config.dir.name")) continue;
                    configMetadataServerdirectory = (String)m_privateProps.get(propName);
                    break;
                }
            }
        }
        return configMetadataServerdirectory;
    }

    private static List retrieveObjects(MdFactory m_Factory, MdStore objectStore, String strReposId, String strMetadataType, int xmlFlags, String xmlOptions) throws MdException {
        int flags = xmlFlags;
        List objectList = null;
        try {
            String foundationReposId = m_Factory.getOMIUtil().getFoundationReposID();
            if (strReposId != null) {
                objectList = m_Factory.getOMIUtil().getMetadataObjectsSubset(objectStore, strReposId, strMetadataType, flags, xmlOptions, false);
                if (!strReposId.equalsIgnoreCase(foundationReposId)) {
                    List subList = m_Factory.getOMIUtil().getMetadataObjectsSubset(objectStore, foundationReposId, strMetadataType, flags, xmlOptions, false);
                    if (objectList != null) {
                        objectList.addAll(subList);
                    } else {
                        objectList = subList;
                    }
                }
            } else {
                objectList = m_Factory.getOMIUtil().getMetadataObjectsSubset(objectStore, foundationReposId, strMetadataType, flags, xmlOptions, false);
            }
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
        return objectList;
    }
}

