/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.workspace.mgmt.MetadataSearchEvent;
import com.sas.workspace.mgmt.MetadataSearchListener;
import java.util.List;
import java.util.Vector;

public abstract class MetadataSearchModel {
    private IOMI m_iOMI = null;
    private MdObjectStore m_store = null;
    private String m_strReposID = null;
    private List m_searchListenerList = null;

    public MetadataSearchModel(IOMI iOMI, MdObjectStore store, String reposID) {
        this.m_iOMI = iOMI;
        this.m_store = store;
        this.m_strReposID = reposID;
        this.m_searchListenerList = new Vector();
    }

    public IOMI getIOMI() {
        return this.m_iOMI;
    }

    public MdObjectStore getObjectStore() {
        return this.m_store;
    }

    public String getRepositoryID() {
        return this.m_strReposID;
    }

    public abstract void search();

    public synchronized void addMetadataSearchListener(MetadataSearchListener listener) {
        this.m_searchListenerList.add(listener);
    }

    public synchronized void removeMetadataSearchListener(MetadataSearchListener listener) {
        this.m_searchListenerList.remove(listener);
    }

    public synchronized void fireSearchPerformed(MetadataSearchEvent event) {
        for (int listenerIndex = this.m_searchListenerList.size() - 1; listenerIndex >= 0; --listenerIndex) {
            MetadataSearchListener listener = (MetadataSearchListener)this.m_searchListenerList.get(listenerIndex);
            listener.processResults(event);
        }
    }

    public void dispose() {
        this.m_searchListenerList = null;
    }
}

