/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.mgmt;

import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class CustomRepository {
    private static WAdminResource bundle = WAdminResource.getBundle(CustomRepository.class);
    protected Repository m_repos;
    protected String m_strFQID;

    public CustomRepository(Repository rep) {
        if (!rep.isCustom()) {
            throw new IllegalArgumentException(bundle.getString("CustomRepository.IllegalType.txt"));
        }
        this.m_repos = rep;
        this.m_strFQID = rep.getId();
    }

    public Repository getRepository() {
        return this.m_repos;
    }

    public boolean checkedOutObjectsExist() throws MdException, RemoteException {
        List resultList = null;
        String strReposId = this.m_strFQID.substring(9, 17);
        String strSelect = "<XMLSELECT search=\"*[@ChangeState ? 'Checked-out to']\"/>";
        int flags = 144;
        try {
            resultList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsNoCache("Root", this.m_strFQID, strSelect, flags);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        if (resultList == null || resultList.size() == 0) {
            return false;
        }
        resultList.clear();
        resultList = null;
        return true;
    }
}

