/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.importcubes;

import com.sas.management.deployment.DeployMetadata;
import com.sas.management.deployment.DeploymentException;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.TextStore;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.importcubes.DeployCube;
import com.sas.olapadmin.importcubes.ImportUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.UpgradeInterface;
import com.sas.workspace.WAdminResource;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

public class ImportCubesMain
extends BatchDriver2 {
    protected static WAdminResource bundle = new WAdminResource(ImportCubesMain.class);
    public static final String OPTION_INPUT_DIRECTORY = "inputDirectory";
    public static final String OPTION_LOG_FILE_DIRECTORY = "logFileDirectory";
    private static final String XML_STR = ".xml";
    private static final String TEXTROLE = "Note";
    private static final String LOGFILE_PREFIX = "ImportCubes";
    private static DeployMetadata importCubes = null;
    private String inputDirectory;
    private String logFileDirectory;

    public ImportCubesMain() {
        this._logFilePrefix = LOGFILE_PREFIX;
        this._logContextName = "com.sas.olapadmin.importcubes";
        this._logTimestamps = false;
        this._logFileDisabled = false;
        this.setLogFilePrefix(LOGFILE_PREFIX);
        this.setAppendToLogFile(false);
        this.setLogFileTimestamp(true);
    }

    public ImportCubesMain(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public ImportCubesMain(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    public void initialize() throws ServiceException, LogicalTypeException, RemoteException {
        super.initialize();
        super.initializeWorkspace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importCubes() throws RemoteException, ServiceException {
        int numberOfCubesSuccessful = 0;
        int numberOfCubesFailedToImport = 0;
        int numberOfFilesRead = 0;
        MdObjectStore objectStore = null;
        try {
            this.logFileDirectory = this._commandLine.getOptionValue("log");
            if (this.logFileDirectory == null) {
                this.logFileDirectory = System.getProperty("user.home");
            }
            this.initialize();
            this._logger.info(bundle.formatString("ImportCubesMain.Start.fmt.txt", (Object)new Date()));
            this.logConnectionInfo();
            File dir = new File(this.inputDirectory);
            if (!dir.exists()) {
                String sMessage = bundle.formatString("ImportCubesMain.DirectoryError.fmt.txt", (Object)this.inputDirectory);
                throw new Exception(sMessage);
            }
            importCubes = new DeployMetadata(Factory.getInstance().getMdFactory());
            objectStore = importCubes.getFactory().createObjectStore(null, "ImportCubesMain");
            XMLFileFilter filter = new XMLFileFilter();
            String[] listOfXMLFiles = dir.list(filter);
            for (int i = 0; i < listOfXMLFiles.length; ++i) {
                String inputfile = "";
                try {
                    String filename = listOfXMLFiles[i];
                    inputfile = this.inputDirectory + System.getProperty("file.separator") + filename;
                    this._logger.info(bundle.formatString("ImportCubesMain.FileProcess.fmt.txt", (Object)inputfile));
                    DeployCube deployCube = new DeployCube(inputfile, importCubes.getFactory());
                    ++numberOfFilesRead;
                    deployCube.prepareDeploy(this._logger);
                    deployCube.makeConnections(this._logger);
                    deployCube.createUniqueCubeName(objectStore, this._logger);
                    deployCube.deploy();
                    Cube cube = ImportUtil.getCube(deployCube.getTargetOLAPSchemaName(), deployCube.getNewCubeName(), objectStore, Factory.getInstance().getMdFactory());
                    if (cube != null) {
                        cube.setPublicType("Cube");
                        cube.updateMetadataAll();
                        MetadataInterface smartObject = ModelUtilities.getSmartObject((CMetadata)cube);
                        if (smartObject != null && smartObject instanceof UpgradeInterface) {
                            UpgradeInterface upgrade = (UpgradeInterface)smartObject;
                            upgrade.upgradeFromPreviousVersion();
                            smartObject.update();
                        }
                        this.upgradeNotes(cube);
                    }
                    this._logger.info(bundle.formatString("ImportCubesMain.CubeSuccess.fmt.txt", (Object)cube.getName()));
                    ++numberOfCubesSuccessful;
                    continue;
                }
                catch (DeploymentException e) {
                    this._logger.error(e.getLocalizedMessage());
                    ++numberOfCubesFailedToImport;
                    this._rc |= 8;
                    continue;
                }
                catch (IOException e) {
                    this._logger.error(bundle.formatString("ImportCubesMain.Failure.fmt.txt", (Object)e.getLocalizedMessage()));
                    ++numberOfCubesFailedToImport;
                    this._rc |= 8;
                    continue;
                }
                catch (MdException e) {
                    this._logger.error(bundle.formatString("ImportCubesMain.Failure.fmt.txt", (Object)e.getLocalizedMessage()));
                    ++numberOfCubesFailedToImport;
                    this._rc |= 8;
                    continue;
                }
                finally {
                    this._logger.info(bundle.formatString("ImportCubesMain.FileProcessEnd.fmt.txt", (Object)inputfile));
                }
            }
        }
        catch (Exception e) {
            this._logger.error(e.getLocalizedMessage());
            this._rc |= 8;
        }
        finally {
            this._logger.info(bundle.formatString("ImportCubesMain.NumFiles.fmt.txt", (Object)Integer.toString(numberOfFilesRead)));
            this._logger.info(bundle.formatString("ImportCubesMain.NumSuccess.fmt.txt", (Object)Integer.toString(numberOfCubesSuccessful)));
            this._logger.info(bundle.formatString("ImportCubesMain.NumFailure.fmt.txt", (Object)Integer.toString(numberOfCubesFailedToImport)));
            this._logger.info(bundle.formatString("ImportCubesMain.End.fmt.txt", (Object)new Date()));
            if (objectStore != null) {
                objectStore.dispose();
            }
            this.terminate();
        }
        return this._rc;
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new Options();
        super.parse(args);
        if (this._help) {
            return;
        }
        if (this._commandLine.hasOption(OPTION_INPUT_DIRECTORY)) {
            this.inputDirectory = this._commandLine.getOptionValue(OPTION_INPUT_DIRECTORY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ImportCubesMain importCubes = new ImportCubesMain();
        int rc = 0;
        try {
            importCubes.parse(args);
            if (importCubes._help) {
                HelpFormatter help = new HelpFormatter();
                org.apache.commons.cli.Options helpOptions = ImportCubesMain.getHelpOptions((org.apache.commons.cli.Options)importCubes._options, null);
                help.printHelp(80, ImportCubesMain.getUsage(help), bundle.getString("ImportCubesMain.Options.txt"), helpOptions, null);
                return;
            }
            rc = importCubes.importCubes();
        }
        catch (ParseException e) {
            System.err.println(bundle.getString("ImportCubesMain.InvalidOptions.txt"));
            System.err.println(e.getLocalizedMessage());
            rc = 8;
        }
        catch (Exception e) {
            System.err.println(bundle.formatString("ImportCubesMain.Failed.fmt.txt", (Object)e.getLocalizedMessage()));
            rc = 8;
        }
        finally {
            if (importCubes != null) {
                rc |= importCubes.getReturnCode();
                String logFileName = importCubes.getLogFileName();
                if (logFileName != null) {
                    System.out.println(bundle.formatString("ImportCubesMain.ViewLog.fmt.txt", (Object)logFileName));
                }
            }
        }
        System.exit(rc);
    }

    private void upgradeNotes(Cube cube) {
        try {
            AssociationList notes = cube.getNotes();
            for (int i = notes.size() - 1; i >= 0; --i) {
                TextStore ts = (TextStore)notes.get(i);
                String role = ts.getTextRole();
                if (!TEXTROLE.equals(role)) continue;
                ts.updateMetadataAll();
                TransportableTypeInterface typeInterface = (TransportableTypeInterface)Factory.getInstance().getTypeInterface(TEXTROLE);
                typeInterface.getImportListener();
            }
        }
        catch (RemoteException e) {
            this._logger.error(e.getLocalizedMessage());
        }
        catch (MdException e) {
            this._logger.error(e.getLocalizedMessage());
        }
        catch (LogicalTypeException e) {
            this._logger.error(e.getLocalizedMessage());
        }
    }

    private static String getUsage(HelpFormatter help) {
        StringBuffer usage = new StringBuffer();
        usage.append(bundle.getString("ImportCubesMain.HelpUsage.txt"));
        return usage.toString();
    }

    protected class Options
    extends BatchDriverOptions {
        public Options() {
            Option option = new Option(ImportCubesMain.OPTION_INPUT_DIRECTORY, true, bundle.getString("ImportCubesMain.Help.InputDirectory.txt"));
            option.setRequired(true);
            this.addOption(option);
        }
    }

    private class XMLFileFilter
    implements FilenameFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(ImportCubesMain.XML_STR);
        }
    }
}

