/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.visuals;

import com.sas.metadata.logical.scheduler.visuals.PromptUtilities;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.visuals.swing.FlowCompletionPanel;
import com.sas.scheduler.visuals.swing.FlowEmailNotificationPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.SchedulerServerPanel;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class FlowPropertiesAttributesTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(FlowPropertiesAttributesTab.class);
    private SchedulerServerPanel m_pnlSchedulerServerPanel;
    private FlowEmailNotificationPanel m_pnlEmailNotificationPanel;
    private StandardPanel m_queuePanel;
    private JComboBox m_queues;
    private JLabel m_lblqueues;
    private FlowCompletionPanel m_pnlFlowCompletionPanel;
    private Frame m_frame;
    private DeployedFlow m_flow;
    private String m_message = "";
    private ArrayList<SchedulerServerInfo> m_serverList = new ArrayList();
    private Scheduler m_previousServer;
    private WAPropertyTab m_dependentTab = null;

    public FlowPropertiesAttributesTab(Frame frame, DeployedFlow flow) throws SchedulerException {
        this.m_frame = frame;
        this.m_flow = flow;
        this.setHelpProduct("shared");
        this.setHelpTopic("attr_tab");
        this.initialize();
        this.layOutWidgets();
        this.setFlowCompleteEnabled();
        this.setEmailNotificationEnabled();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_pnlSchedulerServerPanel.saveSettingsAndCleanUp();
        this.m_pnlSchedulerServerPanel = null;
        this.m_pnlEmailNotificationPanel = null;
        this.m_pnlFlowCompletionPanel = null;
        this.m_frame = null;
        this.m_flow = null;
        this.m_message = null;
        this.m_serverList = null;
        this.m_queuePanel = null;
        this.m_queues = null;
        this.m_lblqueues = null;
    }

    public void initialize() {
        block9: {
            try {
                MdObjectStore store = this.m_flow.getStore();
                String flowId = this.m_flow.getMetadataObject().getFQID();
                String reposId = "A0000001." + flowId.substring(0, 8);
                List list = MetaUtilities.getSchedulerServers((int)100, (MdStore)store, (String)reposId);
                SchedulerServerInfo dinfo = null;
                for (ServerComponent s : list) {
                    SchedulerServerInfo sinfo = new SchedulerServerInfo(s.getName(), s.getClassIdentifier());
                    sinfo.setId(s.getFQID());
                    this.m_serverList.add(sinfo);
                    ServerComponent t = this.m_flow.getSchedulerComponent();
                    if (t == null || !t.getFQID().equalsIgnoreCase(s.getFQID())) continue;
                    dinfo = sinfo;
                }
                this.m_pnlSchedulerServerPanel = new SchedulerServerPanel(this.m_serverList, dinfo);
                this.m_pnlSchedulerServerPanel.addComboListener((ActionListener)new ServerChangedListener());
                this.m_queues = new JComboBox();
                this.m_queues.setToolTipText(m_bundle.getString("FlowPropertiesAttributesTab.Queues.ToolTip.txt"));
                String queueText = m_bundle.getString("FlowPropertiesAttributesTab.Queues.txt");
                this.m_lblqueues = new JLabel(Util.getLabelWithoutMnemonic((String)queueText));
                this.m_lblqueues.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)queueText));
                this.m_lblqueues.setLabelFor(this.m_queues);
                Scheduler scheduler = this.m_flow.getSchedulingServer();
                boolean checkrc = false;
                if (scheduler != null) {
                    FlowPropertiesAttributesTab.resetQueues(this.m_frame, this.m_flow, this.m_queues, this.m_lblqueues, scheduler, checkrc);
                } else {
                    this.m_queues.setModel(new DefaultComboBoxModel());
                    this.m_lblqueues.setEnabled(false);
                    this.m_queues.setEnabled(false);
                }
                this.m_queues.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        FlowPropertiesAttributesTab.this.m_flow.setQueue((String)FlowPropertiesAttributesTab.this.m_queues.getSelectedItem());
                    }
                });
                this.m_flow.setDirty();
                this.m_previousServer = this.m_flow.getSchedulingServer();
                FlowInfo info = this.m_flow.getInfo();
                this.m_pnlFlowCompletionPanel = new FlowCompletionPanel(this.m_frame, info);
                this.m_queuePanel = new StandardPanel();
                this.m_pnlEmailNotificationPanel = new FlowEmailNotificationPanel(this.m_frame, info);
            }
            catch (SchedulerException ex) {
                this.m_message = ex.getLocalizedMessage();
            }
            catch (MdException ex) {
                this.m_message = ex.getLocalizedMessage();
            }
            catch (RemoteException ex) {
                this.m_message = ex.getLocalizedMessage();
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
                this.m_message = m_bundle.getString("FlowPropertiesAttributesTab.UnableToReadFlowInformation.txt");
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                this.m_message = ex.getLocalizedMessage();
                if (this.m_message != null) break block9;
                this.m_message = ex.toString();
            }
        }
    }

    private void layOutWidgets() {
        this.m_queuePanel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints lblqueues_gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints queues_gbc = new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 0, 0), 0, 0);
        this.m_queuePanel.setBorder((Border)new EtchedBorder());
        this.m_queuePanel.add((Component)this.m_lblqueues, (Object)lblqueues_gbc);
        this.m_queuePanel.add((Component)this.m_queues, (Object)queues_gbc);
        this.setLayout(new GridBagLayout());
        GridBagConstraints scheduler_gbc = new GridBagConstraints(0, 0, 7, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints completion_gbc = new GridBagConstraints(0, 1, 4, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints queue_gbc = new GridBagConstraints(4, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints email_gbc = new GridBagConstraints(4, 2, 3, 1, 1.0, 1.0, 18, 3, new Insets(5, 0, 0, 0), 0, 0);
        this.add((Component)this.m_pnlSchedulerServerPanel, scheduler_gbc);
        this.add((Component)this.m_pnlFlowCompletionPanel, completion_gbc);
        this.add((Component)this.m_queuePanel, queue_gbc);
        this.add((Component)this.m_pnlEmailNotificationPanel, email_gbc);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    public void populateStore() {
        if (this.isStorePopulated()) {
            return;
        }
        this.setListeningForChanges(false);
        this.setStorePopulated(true);
        this.setListeningForChanges(true);
    }

    public void moveDataToView() {
        this.setDataChanged(false);
        this.m_pnlFlowCompletionPanel.moveDataToView();
        this.m_pnlEmailNotificationPanel.moveDataToView();
        this.setFlowCompleteEnabled();
        this.setEmailNotificationEnabled();
    }

    public void moveDataToStore() {
        if (this.m_flow != null) {
            try {
                this.m_pnlEmailNotificationPanel.moveViewToData();
                FlowInfo info = this.m_pnlEmailNotificationPanel.getInfo();
                if (info.emailNotificationLevel() != -1) {
                    this.m_flow.setEmailNotification(true, info.emailNotificationLevel(), info.emailAddress());
                } else {
                    this.m_flow.setEmailNotification(false, -1, null);
                }
                this.m_pnlFlowCompletionPanel.moveViewToData();
                FlowInfo info2 = this.m_pnlFlowCompletionPanel.getInfo();
                if (info2.completionLevel() != 0) {
                    this.m_flow.setCompletion(true, info2.completionLevel(), info2.completionSelectedJobs());
                } else {
                    this.m_flow.setCompletion(false, 0, null);
                }
                this.m_flow.setEndBehavior(info2.getEndBehaviorDataBinding().intValue());
                this.m_flow.setExitcodeBehavior(info2.getExitcodeBehaviorDataBinding().intValue());
            }
            catch (MdException mde) {
                this.m_message = mde.getLocalizedMessage();
            }
            catch (RemoteException re) {
                this.m_message = re.getLocalizedMessage();
            }
            this.m_flow.commitChangesWithNoValidation();
        }
    }

    public boolean validateData() {
        if (this.m_pnlSchedulerServerPanel.validateData()) {
            SchedulerServerInfo ssi = this.m_pnlSchedulerServerPanel.getSelectedServer();
            if (ssi != null && ssi.isEmailNotificationSupported() && !this.m_pnlEmailNotificationPanel.validateData()) {
                return false;
            }
            return ssi == null || !ssi.isAdvanceFlowCompletionCriteriaSupported() || this.m_pnlFlowCompletionPanel.validateData();
        }
        return false;
    }

    public void onParentCancel() {
        super.onParentCancel();
        if (this.m_bDataChanged) {
            try {
                this.m_flow.refresh();
            }
            catch (MdException ex) {
                Workspace.getDefaultLogger().debug((Object)ex.getLocalizedMessage());
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().debug((Object)ex.getLocalizedMessage());
            }
            catch (RuntimeException ex) {
                Workspace.getDefaultLogger().debug((Object)ex.getLocalizedMessage());
            }
            this.setDataChanged(true);
        }
    }

    public void onParentOK() {
        super.onParentOK();
        try {
            this.m_flow.commitChanges();
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().debug((Object)ex.getLocalizedMessage());
        }
    }

    public void setDependentTab(WAPropertyTab tab) {
        this.m_dependentTab = tab;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (bDataChanged) {
            try {
                ServerComponent sc = this.m_flow.getSchedulerComponent();
                Scheduler scheduler = MetaUtilities.getSchedulingServer((ServerComponent)sc);
                scheduler.makeConnection((PromptCallbackInterface)new PromptUtilities());
                this.setFlowCompleteEnabled();
                this.setEmailNotificationEnabled();
                if (this.m_dependentTab != null) {
                    this.m_dependentTab.setDataChanged(bDataChanged);
                }
                scheduler.closeConnection();
            }
            catch (SchedulerException ex) {
                MessageUtil.displayMetadataExceptionMessage((Exception)((Object)ex), (String)m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), (int)2);
                return;
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((Exception)((Object)ex), (String)m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), (int)2);
                return;
            }
            catch (RemoteException ex) {
                return;
            }
        }
        super.setDataChanged(bDataChanged);
    }

    private void setFlowCompleteEnabled() {
        SchedulerServerInfo ssi = this.m_pnlSchedulerServerPanel.getSelectedServer();
        if (ssi != null && ssi.isAdvanceFlowCompletionCriteriaSupported()) {
            this.m_pnlFlowCompletionPanel.setEnabled(true);
        } else {
            this.m_pnlFlowCompletionPanel.setEnabled(false);
        }
    }

    private void setEmailNotificationEnabled() {
        SchedulerServerInfo ssi = this.m_pnlSchedulerServerPanel.getSelectedServer();
        if (ssi != null && ssi.isEmailNotificationSupported()) {
            this.m_pnlEmailNotificationPanel.setEnabled(true);
        } else {
            this.m_pnlEmailNotificationPanel.setEnabled(false);
        }
    }

    public static void resetQueues(Frame frame, DeployedFlow flow, JComboBox queues, JLabel label, Scheduler scheduler, boolean alreadychecked) throws SchedulerException {
        int connected = 0;
        if (scheduler.areQueues()) {
            List q;
            if (!alreadychecked && !scheduler.isConnected()) {
                try {
                    connected = scheduler.makeConnection((PromptCallbackInterface)new PromptUtilities());
                    if (connected != 1) {
                        MessageUtil.displayMessage((Frame)frame, (String)m_bundle.getString("FlowPropertiesAttributesTab.UnableToConnectToScheduler.txt"), (String)m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), (int)2);
                    }
                }
                catch (InvalidParameterException ipe) {
                    MessageUtil.displayMessage((Frame)frame, (String)m_bundle.getString("FlowPropertiesAttributesTab.UnableToConnectToScheduler.txt"), (String)m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), (int)2);
                }
                catch (SchedulerException se) {
                    MessageUtil.displayMessage((Frame)frame, (String)m_bundle.getString("FlowPropertiesAttributesTab.UnableToConnectToScheduler.txt"), (String)m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), (int)2);
                }
            }
            if ((q = scheduler.getQueues()) != null && q.size() > 0) {
                String defaultqueue;
                queues.setModel(new DefaultComboBoxModel<Object>(q.toArray()));
                String string = defaultqueue = flow != null ? flow.getQueue() : null;
                if (defaultqueue != null) {
                    queues.setSelectedItem(defaultqueue);
                }
                label.setEnabled(true);
                queues.setEnabled(true);
            }
            if (connected == 1) {
                scheduler.closeConnection();
            }
        } else {
            queues.setModel(new DefaultComboBoxModel());
            label.setEnabled(false);
            queues.setEnabled(false);
        }
    }

    private class ServerChangedListener
    implements ActionListener {
        private ServerChangedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent it) {
            block31: {
                try {
                    SchedulerServerInfo ssi = FlowPropertiesAttributesTab.this.m_pnlSchedulerServerPanel.getSelectedServer();
                    Scheduler server = MetaUtilities.getSchedulingServer((SchedulerServerInfo)ssi, (MdObjectStore)FlowPropertiesAttributesTab.this.m_flow.getStore());
                    if (server == null) break block31;
                    try {
                        boolean reset = false;
                        boolean remove = false;
                        int response = -1;
                        if (FlowPropertiesAttributesTab.this.m_previousServer == null) {
                            reset = true;
                        } else if (!FlowPropertiesAttributesTab.this.m_previousServer.getServerComponent().getId().equalsIgnoreCase(server.getServerComponent().getId())) {
                            if (FlowPropertiesAttributesTab.this.m_flow.isFlowSubmitted()) {
                                response = JOptionPane.showConfirmDialog(FlowPropertiesAttributesTab.this.m_frame, m_bundle.getString("FlowPropertiesAttributesTab.FlowSubmitted.Remove.txt"), m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), 0);
                                if (0 == response) {
                                    reset = true;
                                    remove = true;
                                } else {
                                    reset = false;
                                    remove = false;
                                }
                            } else {
                                reset = true;
                            }
                        }
                        if (remove) {
                            Scheduler scheduler = FlowPropertiesAttributesTab.this.m_flow.getSchedulingServer();
                            int connected = 0;
                            try {
                                connected = scheduler.makeConnection((PromptCallbackInterface)new PromptUtilities());
                                if (connected != 1 || !scheduler.removeFlow(FlowPropertiesAttributesTab.this.m_flow.getInfo())) {
                                    MessageUtil.displayMessage((Frame)FlowPropertiesAttributesTab.this.m_frame, (String)m_bundle.getString("FlowPropertiesAttributesTab.UnableToRemoveFromScheduler.txt"), (String)m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), (int)2);
                                }
                            }
                            catch (UnsupportedOperationException ex) {
                                MessageUtil.displayMessage((Frame)FlowPropertiesAttributesTab.this.m_frame, (String)m_bundle.getString("FlowPropertiesAttributesTab.UnableToRemoveFromScheduler.txt"), (String)m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), (int)2);
                            }
                            catch (SchedulerException ex) {
                                MessageUtil.displayMessage((Frame)FlowPropertiesAttributesTab.this.m_frame, (String)m_bundle.getString("FlowPropertiesAttributesTab.UnableToRemoveFromScheduler.txt"), (String)m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), (int)2);
                            }
                            finally {
                                if (connected == 1) {
                                    scheduler.closeConnection();
                                }
                            }
                            FlowPropertiesAttributesTab.this.m_flow.removeTriggerEvent();
                        }
                        if (reset) {
                            try {
                                FlowPropertiesAttributesTab.this.m_flow.setFlowSubmitted(false);
                            }
                            catch (RuntimeException ex) {
                                MessageUtil.displayMessage((Frame)FlowPropertiesAttributesTab.this.m_frame, (String)m_bundle.getString("FlowPropertiesAttributesTab.UnableToRemoveFromScheduler.txt"), (String)m_bundle.getString("FlowPropertiesAttributesTab.Title.txt"), (int)2);
                            }
                            FlowPropertiesAttributesTab.this.m_flow.setScheduleServer(server);
                            FlowPropertiesAttributesTab.this.m_previousServer = server;
                            FlowPropertiesAttributesTab.resetQueues(FlowPropertiesAttributesTab.this.m_frame, FlowPropertiesAttributesTab.this.m_flow, FlowPropertiesAttributesTab.this.m_queues, FlowPropertiesAttributesTab.this.m_lblqueues, server, false);
                        }
                        if (remove || reset) {
                            FlowPropertiesAttributesTab.this.m_flow.reevaluateErrors();
                            FlowPropertiesAttributesTab.this.setDataChanged(true);
                        } else {
                            Iterator i = FlowPropertiesAttributesTab.this.m_serverList.iterator();
                            SchedulerServerInfo sinfo = null;
                            while (i.hasNext()) {
                                SchedulerServerInfo info = (SchedulerServerInfo)i.next();
                                if (FlowPropertiesAttributesTab.this.m_previousServer == null || info.getId().compareToIgnoreCase(FlowPropertiesAttributesTab.this.m_previousServer.getServerComponent().getId()) != 0) continue;
                                sinfo = info;
                                break;
                            }
                            if (sinfo != null) {
                                FlowPropertiesAttributesTab.this.m_pnlSchedulerServerPanel.setSelectedServer(sinfo);
                            }
                        }
                    }
                    catch (SchedulerException ex) {
                        return;
                    }
                    catch (MdException ex) {
                        return;
                    }
                    catch (RemoteException ex) {
                        return;
                    }
                }
                catch (RemoteException re) {
                    return;
                }
                catch (SchedulerException mde) {
                    return;
                }
            }
        }
    }
}

