/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.io.InputStreamAdapter;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.scheduler.job.DeployedJobImportItem;
import com.sas.metadata.logical.scheduler.visuals.FlowPromotionOptionsPanel;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

@SASScope
public class DeployedJobPromotionOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(FlowPromotionOptionsPanel.class);
    private TriStateCheckBox _ckbContent;
    private boolean _isExport;
    private boolean _dataChanged;
    private SimpleLogicalObjectInterface[] m_aItems;

    public DeployedJobPromotionOptionsPanel(int iPromotionType) {
        this._isExport = iPromotionType != 1;
        this._ckbContent = new TriStateCheckBox();
        Util.configureMnemonicForButton((AbstractButton)this._ckbContent, (String)m_bundle.getString("DeployedJobPromotionOptionsPanel.ckbContent.txt"));
        this._ckbContent.setToolTipText(m_bundle.getString("DeployedJobPromotionOptionsPanel.ckbContent.ToolTip.txt"));
        this._ckbContent.setCycleEnabled(false);
        this._ckbContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployedJobPromotionOptionsPanel.this._dataChanged = true;
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this._ckbContent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateExportOptions(ExportItemInterface[] aItems) {
        this.m_aItems = aItems;
        this._ckbContent.setSelectedValue(this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems));
    }

    public void populateImportOptions(ImportItemInterface[] aItems, PromotionPropertiesFile propertiesFile) {
        this.m_aItems = aItems;
        boolean bNoContent = false;
        for (int i = 0; i < aItems.length; ++i) {
            String exclude = propertiesFile.getProperty(aItems[i].getID() + "_ExcludeContent");
            if (exclude == null) {
                exclude = "true";
                try {
                    ImportItemInterface importItem = aItems[i];
                    ContentHandlerInterface handler = importItem.getImportOperation().getContentHandler();
                    int version = handler.getPackageVersion();
                    Map contentMap = null;
                    contentMap = version < 9200 ? handler.getBinaryContent(importItem.getID()) : handler.getTextContent(importItem.getID());
                    for (Map.Entry element : contentMap.entrySet()) {
                        String key = (String)element.getKey();
                        if (!"###SCHJOB###".equals(key)) continue;
                        Reader in = null;
                        if (version < 9200) {
                            InputStreamAdapter file = (InputStreamAdapter)element.getValue();
                            in = new InputStreamReader((InputStream)file);
                        } else {
                            in = (Reader)element.getValue();
                        }
                        StringBuffer buffer = new StringBuffer();
                        char[] dataBuffer = new char[1024];
                        int charsRead = in.read(dataBuffer);
                        while (charsRead > 0) {
                            buffer.append(dataBuffer, 0, charsRead);
                            charsRead = in.read(dataBuffer);
                        }
                        String batchServerClassid = null;
                        batchServerClassid = buffer.charAt(0) == '\r' && buffer.charAt(1) == '\n' ? MetaUtilities.replaceString((String)buffer.toString().substring(2), (String)"\r\n", (String)"") : MetaUtilities.replaceString((String)buffer.toString().substring(1), (String)"\r\n", (String)"");
                        int batchType = BatchServerInfo.getType((String)batchServerClassid);
                        if (batchType == 1) {
                            exclude = "false";
                            continue;
                        }
                        exclude = "true";
                    }
                }
                catch (Exception ioe) {
                    exclude = "false";
                    ioe.getStackTrace();
                }
            }
            if (!"true".equals(exclude)) continue;
            ((DeployedJobImportItem)aItems[i]).setIncludeContent(false);
            bNoContent = true;
            break;
        }
        if (bNoContent) {
            this._ckbContent.setSelectedValue(0);
            this._ckbContent.setEnabled(false);
            return;
        }
        this._ckbContent.setEnabled(true);
        this._ckbContent.setSelectedValue(this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems));
    }

    public void saveSettings() {
        if (!this._dataChanged) {
            return;
        }
        if (!this._isExport) {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                ((DeployedJobImportItem)this.m_aItems[i]).setIncludeContent(this._ckbContent.isSelected());
            }
        }
        this._dataChanged = false;
    }

    private int determineCheckBoxState(SimpleLogicalObjectInterface[] aItems) {
        boolean bAllOn = true;
        boolean bAllOff = true;
        for (int i = 0; i < this.m_aItems.length; ++i) {
            boolean bOn = this._isExport ? true : ((DeployedJobImportItem)this.m_aItems[i]).getIncludeContent();
            bAllOn &= bOn;
            bAllOff &= !bOn;
        }
        if (bAllOn) {
            return 2;
        }
        if (bAllOff) {
            return 0;
        }
        return 1;
    }
}

