/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.flow;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowExportItem;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowImportListener;
import com.sas.metadata.logical.scheduler.schedulingservers.SchedulingServerConnectionType;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.services.TransportException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;

public class DeployedFlowExportListener
extends AbstractExportListener {
    public DeployedFlowExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new DeployedFlowExportItem(name, id, type);
    }

    public Class[] getConnectionTypes() {
        return DeployedFlowImportListener.CONNECTION_TYPES;
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException {
        StringBuffer xmlbuffer = new StringBuffer();
        Iterator i = objects.iterator();
        try {
            MdObjectStore store = operation.getStore();
            String repos = operation.getRepositoryID();
            while (i.hasNext()) {
                ExportItemInterface exportItem = (ExportItemInterface)i.next();
                String fqid = exportItem.getID();
                JFJob jfjob = MetaUtilities.getJFJob((String)fqid, (MdStore)store, (String)repos);
                DeployedFlow flow = null;
                ServerComponent sc = DeployedFlow.getSchedulerComponent((JFJob)jfjob);
                flow = operation.isBatchProcess() && sc.getClassIdentifier().compareTo("c8b4baf0-5f9f-488e-ba76-1201e1e81aef") == 0 ? new DeployedFlow(jfjob) : new DeployedFlow(jfjob, store);
                xmlbuffer.append("<xmlFlowDef Name=\"" + flow.getName() + "\" Version=\"1.0\">\n");
                xmlbuffer.append(flow.getXML(true).toString());
                xmlbuffer.append("</xmlFlowDef>\n");
                StringReader reader = new StringReader(xmlbuffer.toString());
                operation.getContentHandler().addTextContent(fqid, "###SCHFLOW###", (Reader)reader);
            }
        }
        catch (SchedulerException se) {
            return 8;
        }
        catch (MdException mde) {
            return 8;
        }
        return 0;
    }

    public int analyzeConnections(ExportOperationInterface operation, List objects) throws MdException, RemoteException {
        ConnectionManagerInterface manager = operation.getConnectionManager();
        List schedulerConnectionPoints = manager.getConnections(ConnectionObjectType.MetadataType, "ServerComponent");
        for (ConnectionPointInterface pt : schedulerConnectionPoints) {
            if (!SchedulingServerConnectionType.isScheduler(pt)) continue;
            pt.addUserDefinedProperty("ServerType", "Scheduler");
        }
        return 0;
    }
}

