/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.flow;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;

public class DeployedFlowExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    private JFJob m_jfjob;

    public DeployedFlowExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
        try {
            Factory lfactory = Factory.getInstance();
            MdObjectStore store = lfactory.getScratchStore();
            String repos = PromotionUtil.getRepositoryID((String)id);
            this.m_jfjob = MetaUtilities.getJFJob((String)id, (MdStore)store, (String)repos);
        }
        catch (SchedulerException se) {
            this.m_jfjob = null;
        }
        catch (RemoteException re) {
            this.m_jfjob = null;
        }
        catch (MdException mde) {
            this.m_jfjob = null;
        }
    }

    public List<SimpleLogicalObjectInterface> getRelatedObjects(int relationshipType) throws LogicalTypeException {
        Vector<SimpleLogicalObjectInterface> objectList = new Vector<SimpleLogicalObjectInterface>();
        if (this.m_jfjob == null) {
            return null;
        }
        if (relationshipType == 0) {
            try {
                String id = this.m_jfjob.getId();
                Factory lfactory = Factory.getInstance();
                MdObjectStore store = lfactory.getScratchStore();
                String repos = PromotionUtil.getRepositoryID((String)id);
                FlowInfo flow = DeployedFlow.getInfo((JFJob)this.m_jfjob, (MdObjectStore)store, (boolean)false);
                List jobs = flow.getJobsDataBinding();
                for (Object obj : jobs) {
                    SimpleLogicalObjectInterface logicalUser;
                    SimpleLogicalObjectInterface logicalUser2;
                    JobInfo info;
                    if (obj instanceof JobInfo) {
                        info = (JobInfo)obj;
                        JFJob job = MetaUtilities.getJFJob((String)info.getId(), (MdStore)store, (String)repos);
                        logicalUser2 = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)job);
                        if (logicalUser2 == null) continue;
                        objectList.add(logicalUser2);
                        continue;
                    }
                    if (obj instanceof FlowInfo) {
                        info = (FlowInfo)obj;
                        JFJob subflow = MetaUtilities.getJFJob((String)info.getId(), (MdStore)store, (String)repos);
                        logicalUser2 = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)subflow);
                        if (logicalUser2 == null) continue;
                        objectList.add(logicalUser2);
                        continue;
                    }
                    if (obj instanceof DeployedJob) {
                        logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)((DeployedJob)obj).getDeployedJobObject());
                        if (logicalUser == null) continue;
                        objectList.add(logicalUser);
                        continue;
                    }
                    if (!(obj instanceof DeployedFlow) || (logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)((DeployedFlow)obj).getMetadataObject())) == null) continue;
                    objectList.add(logicalUser);
                }
            }
            catch (SchedulerException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            catch (MdException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            catch (RemoteException re) {
                throw new LogicalTypeException((Exception)re);
            }
        }
        if (relationshipType == 1) {
            try {
                List flows = DeployedFlow.getListofFlows((JFJob)this.m_jfjob);
                int num = flows.size();
                for (int j = 0; j < num; ++j) {
                    JFJob usedByFlow = (JFJob)flows.get(j);
                    SimpleLogicalObjectInterface logicalUser = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)usedByFlow);
                    if (logicalUser == null) continue;
                    objectList.add(logicalUser);
                }
            }
            catch (MdException mde) {
                throw new LogicalTypeException((Exception)((Object)mde));
            }
            catch (RemoteException re) {
                throw new LogicalTypeException((Exception)re);
            }
        }
        return objectList;
    }
}

