/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.flow;

import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.scheduler.api.oma.MetaUtilities;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class DeployedFlowConnectionType
extends AbstractConnectionType
implements ConnectionTypeInterface {
    private static final String TYPE_NAME = "Deployed Flow";
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedFlowConnectionType.class);
    private List<SourceConnectionInterface> _deployedFlowConnections;

    public DeployedFlowConnectionType(PromotionInterface promotionOperation) {
        super(promotionOperation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public String getLocalizedTypeName() {
        return m_bundle.getString("DeployedFlowConnectionType.ConnectionType.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.scheduler.visuals.SubFlowConnectionPanel";
    }

    public List<SourceConnectionInterface> getSourceConnections() {
        if (this._deployedFlowConnections == null) {
            List subflowConnectionPoints = this._connectionManager.getConnections(ConnectionObjectType.PublicType, "DeployedFlow");
            this._deployedFlowConnections = new ArrayList<SourceConnectionInterface>(subflowConnectionPoints.size());
            for (ConnectionPointInterface pt : subflowConnectionPoints) {
                if ("SCHEDULER_FLOW".compareTo(DeployedFlowConnectionType.getTransformRole(pt)) != 0) continue;
                SourceConnectionInterface sourceConnection = this.createSourceConnection(pt, pt.getName());
                this._deployedFlowConnections.add(sourceConnection);
            }
        }
        return this._deployedFlowConnections;
    }

    public List<TargetConnectionInterface> getTargetConnections() throws MdException, RemoteException {
        MdObjectStore store = this._operation.getStore();
        List targetSubFlows = MetaUtilities.getJFJobList((String)"SCHEDULER_FLOW", (MdObjectStore)store, (String)this._operation.getRepositoryID());
        ArrayList<TargetConnectionInterface> tables = new ArrayList<TargetConnectionInterface>(targetSubFlows.size());
        for (CMetadata jfjob : targetSubFlows) {
            tables.add(this.createTargetConnection(jfjob, jfjob.getName()));
        }
        return tables;
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return false;
    }

    public static String getTransformRole(ConnectionPointInterface pt) {
        String searchAttribute = pt.getSourceSearchString();
        int startIndex = searchAttribute.indexOf("TransformRole");
        if (startIndex > -1) {
            int len = startIndex + "TransformRole".length() + 2;
            return searchAttribute.substring(len, searchAttribute.indexOf("'", len));
        }
        return null;
    }
}

