/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.util.security;

import com.sas.services.security.RemoteNameCallback;
import com.sas.webapp.util.security.AuthToken;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.ServletRequest;

public class MidTierAuthCallbackHandler
implements CallbackHandler {
    private ServletRequest _request;
    private String _authPromptUrl;

    public MidTierAuthCallbackHandler(ServletRequest request, String authPromptUrl) {
        this._request = request;
        this._authPromptUrl = authPromptUrl;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String failedDomain = this.extractDomain(callbacks);
        if (failedDomain == null) {
            return;
        }
        AuthToken token = new AuthToken(failedDomain, this._authPromptUrl);
        this._request.setAttribute("sasMidTierAuthToken", (Object)token);
    }

    private String extractDomain(Callback[] callbacks) {
        String failedDomain = null;
        if (callbacks != null) {
            for (int x = 0; x < callbacks.length; ++x) {
                RemoteNameCallback rnc;
                String prompt;
                int breakpos;
                if (!(callbacks[x] instanceof RemoteNameCallback) || (breakpos = (prompt = (rnc = (RemoteNameCallback)callbacks[x]).getPrompt()).lastIndexOf(" ")) <= -1) continue;
                failedDomain = prompt.substring(breakpos + 1);
                break;
            }
        }
        return failedDomain;
    }
}

