/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.themes.util;

import com.sas.midtier.components.container.util.impl.ComponentsUtil;
import com.sas.preferences.SASProfileInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.webapp.themes.Image;
import com.sas.webapp.themes.Theme;
import com.sas.webapp.themes.components.ThemesManager;
import com.sas.webapp.themes.util.res.RB;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThemesUtil {
    private static final Theme getTheme(String name, UserContextInterface uc, HttpServletRequest request) throws RemoteException {
        Theme theme = null;
        ThemesManager tf = (ThemesManager)ComponentsUtil.locateComponent(ThemesManager.class, (HttpServletRequest)request);
        Logger logger = LogManager.getLogger(ThemesUtil.class);
        if (!tf.isValidTheme(name)) {
            if (uc != null) {
                logger.warn(RB.getStringResource("error.theme.txt", request.getLocale()), (Object)uc);
            } else {
                logger.warn(RB.getStringResource("error.theme.txt", request.getLocale()));
            }
            theme = (Theme)request.getAttribute("sas.framework.themeobject");
        } else {
            theme = tf.getTheme(name);
        }
        return theme;
    }

    public static final Theme getDefaultTheme(UserContextInterface uc, HttpServletRequest request) throws RemoteException {
        return ThemesUtil.getTheme("default", uc, request);
    }

    public static final Theme getTheme(UserContextInterface uc, HttpServletRequest request) throws RemoteException {
        return (Theme)request.getAttribute("sas.framework.themeobject");
    }

    public static String getThemeName(HttpServletRequest request) throws RemoteException {
        Theme theme = (Theme)request.getAttribute("sas.framework.themeobject");
        return theme.getName();
    }

    public static String getThemeBackground(HttpServletRequest request) throws RemoteException {
        Image b;
        String themeBackground = "white";
        Theme theme = (Theme)request.getAttribute("sas.framework.themeobject");
        if (theme != null && (b = theme.getImage("banner_background")) != null) {
            themeBackground = b.getFile();
        }
        return themeBackground;
    }

    public static String getThemeName(UserContextInterface uc, HttpServletRequest request) throws RemoteException {
        return ThemesUtil.getThemeName(request);
    }

    public static String getThemeStyles(SASProfileInterface profile, HttpServletRequest request) throws Exception {
        Theme theme = ThemesUtil.getTheme(profile, request);
        Iterator itStyles = theme.getStyleSheets("SCREEN").iterator();
        StringBuffer sb = new StringBuffer();
        while (itStyles.hasNext()) {
            sb.append("<link rel=stylesheet href=\"" + (String)itStyles.next() + "\" type=\"text/css\">\n");
        }
        return sb.toString();
    }

    public static Theme getTheme(SASProfileInterface profile, HttpServletRequest request) throws Exception {
        return (Theme)request.getAttribute("sas.framework.themeobject");
    }
}

