/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.themes.components.impl;

import com.sas.midtier.components.container.StorageContext;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.webapp.components.services.TrustedOmrUser;
import com.sas.webapp.themes.Theme;
import com.sas.webapp.themes.ThemeException;
import com.sas.webapp.themes.components.ThemesManager;
import com.sas.webapp.themes.components.impl.DefaultThemesManagerInitializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ThemesManagerImpl
implements ThemesManager,
Serializable {
    private static final long serialVersionUID = 73038865023306077L;
    private static final String _loggingContext = ThemesManagerImpl.class.getName();
    private Logger _logger;
    private UserContextInterface _omrUser;
    private Map _allMaps = new Hashtable();
    private Map _allThemes = new Hashtable();
    private boolean _image = false;
    private boolean _images = false;
    private boolean _styles = false;
    private boolean _styleSheet = false;
    private boolean _template = false;
    private boolean _templates = false;
    private boolean _theme = false;
    private Map _directories = null;
    private String[] _imageArray = null;
    private Map _imageMap = null;
    private Map _map = null;
    private String[] _styleArray = null;
    private Map _styleMap = null;
    private String[] _templateArray = null;
    private Map _templateMap = null;
    private boolean _isFinished = false;
    private String _appName;

    public ThemesManagerImpl(StorageContext context, Logger logger, TrustedOmrUser trustedOmrUser) throws InitializationException, RemoteException, ServiceException {
        InputSource source;
        this._logger = logger;
        this._omrUser = trustedOmrUser.getUserContext();
        this._appName = context.getName();
        InputStream in = this.findResource(context, "/fallback/themes/SASthemes.xml");
        StringBuffer fallbackPrefix = new StringBuffer();
        fallbackPrefix.append("/").append(this._appName).append("/fallback");
        if (in != null) {
            source = new InputSource(in);
            try {
                this.addThemeDef(source, fallbackPrefix.toString());
            }
            catch (ThemeException e) {
                this._logger.error(e.getMessage(), (Throwable)((Object)e));
            }
        }
        if ((in = this.findResource(context, "/fallback/themes/SolutionsThemes.xml")) != null) {
            source = new InputSource(in);
            try {
                this.addThemeDef(source, fallbackPrefix.toString());
            }
            catch (ThemeException e) {
                this._logger.error(e.getMessage(), (Throwable)((Object)e));
            }
        }
        DefaultThemesManagerInitializer initializer = new DefaultThemesManagerInitializer(this, this._omrUser, logger);
        try {
            initializer.init();
        }
        catch (ThemeException e) {
            this._logger.warn(e.getMessage());
        }
    }

    @Override
    public List getThemeNames() {
        this.finish();
        List<Object> themeList = new ArrayList();
        themeList = Arrays.asList(this._allThemes.keySet().toArray());
        return themeList;
    }

    @Override
    public Theme getTheme(String name) {
        this.finish();
        Theme candidate = null;
        if (name != null) {
            if (this.isValidTheme(name)) {
                candidate = (Theme)this._allThemes.get(name);
            } else if (this.isValidTheme("default")) {
                candidate = (Theme)this._allThemes.get("default");
            } else {
                System.out.println("Theme " + name + " is not a valid theme, and the \"default\" theme was not available");
            }
        }
        return candidate;
    }

    @Override
    public boolean isValidTheme(String name) {
        this.finish();
        if (name == null) {
            return false;
        }
        return this._allThemes.containsKey(name);
    }

    @Override
    public String getTranslationString(Locale aLocale, String themeName) {
        if (aLocale != null) {
            // empty if block
        }
        this.finish();
        String retVal = null;
        Theme theme = this.getTheme(themeName);
        retVal = theme != null ? theme.getLabel() : "default";
        return retVal;
    }

    @Override
    public List getListOfValidValues() {
        this.finish();
        return this.getThemeNames();
    }

    @Override
    public void addThemeDef(InputSource source, String urlPrefix) throws ThemeException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            ContentDocumentHandler handler = new ContentDocumentHandler(urlPrefix);
            parser.parse(source, (DefaultHandler)handler);
            this._logger.debug("addThemeDef() parsed " + urlPrefix);
        }
        catch (FactoryConfigurationError fce) {
            this._logger.error(fce.getMessage(), (Throwable)fce);
        }
        catch (ParserConfigurationException pce) {
            ThemeException te = new ThemeException("ParserConfigurationException thrown in initialize().", pce);
            te.setMessage("com.sas.webapp.i18n.RB", "ThemesFactory.ParserConfigurationException.txt", null);
            throw te;
        }
        catch (SAXException se) {
            ThemeException te = new ThemeException("SAXException thrown in initialize().", se);
            te.setMessage("com.sas.webapp.i18n.Resources", "ThemesFactory.SAXException.txt", null);
            throw te;
        }
        catch (IOException ioe) {
            ThemeException te = new ThemeException("IOException thrown in initialize().", ioe);
            te.setMessage("com.sas.webapp.i18n.Resources", "ThemesFactory.IOException.txt", null);
            throw te;
        }
    }

    @Override
    public void finish() {
        if (!this._isFinished) {
            this._isFinished = true;
            Collection coll = this._allMaps.values();
            Iterator it = coll.iterator();
            Theme theme = null;
            while (it.hasNext()) {
                theme = new Theme((Map)it.next());
                this._allThemes.put(theme.getName(), theme);
            }
        }
    }

    private InputStream findResource(StorageContext context, String resourceName) {
        InputStream retval = null;
        int tries = 0;
        if (this.verifyPathExists(context, resourceName)) {
            while (retval == null && (retval = context.getResourceAsStream(resourceName)) == null && ++tries <= 10) {
                if (retval != null) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        return retval;
    }

    private boolean verifyPathExists(StorageContext context, String resourceName) {
        boolean retval = false;
        int breakpos = resourceName.lastIndexOf("/");
        if (breakpos > -1) {
            String directory = resourceName.substring(0, breakpos);
            Set paths = context.getResourcePaths(directory);
            retval = paths != null && paths.size() > 0;
        }
        return retval;
    }

    static /* synthetic */ String[] access$1302(ThemesManagerImpl x0, String[] x1) {
        x0._styleArray = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1402(ThemesManagerImpl x0, String[] x1) {
        x0._imageArray = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1502(ThemesManagerImpl x0, String[] x1) {
        x0._templateArray = x1;
        return x1;
    }

    private class ContentDocumentHandler
    extends DefaultHandler {
        String urlPrefix;

        ContentDocumentHandler(String urlPrefix) {
            this.urlPrefix = urlPrefix;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            String attName;
            if (namespaceURI == null || rawName != null) {
                // empty if block
            }
            if (localName.equalsIgnoreCase("theme")) {
                ThemesManagerImpl.this._theme = true;
            }
            if (localName.equalsIgnoreCase("styles")) {
                ThemesManagerImpl.this._styles = true;
            }
            if (localName.equalsIgnoreCase("stylesheet")) {
                ThemesManagerImpl.this._styleSheet = true;
            }
            if (localName.equalsIgnoreCase("images")) {
                ThemesManagerImpl.this._images = true;
            }
            if (localName.equalsIgnoreCase("image")) {
                ThemesManagerImpl.this._image = true;
            }
            if (localName.equalsIgnoreCase("templates")) {
                ThemesManagerImpl.this._templates = true;
            }
            if (localName.equalsIgnoreCase("template")) {
                ThemesManagerImpl.this._template = true;
            }
            if (ThemesManagerImpl.this._theme) {
                String[] themeAtts = new String[6];
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    String attName2 = atts.getLocalName(i);
                    if (attName2.equalsIgnoreCase("name")) {
                        themeAtts[0] = attValue.trim();
                    }
                    if (attName2.equalsIgnoreCase("label")) {
                        themeAtts[1] = attValue.trim();
                    }
                    if (attName2.equalsIgnoreCase("description")) {
                        themeAtts[2] = attValue.trim();
                    }
                    if (attName2.equalsIgnoreCase("device")) {
                        themeAtts[3] = attValue.trim();
                    }
                    if (attName2.equalsIgnoreCase("URIPath")) {
                        themeAtts[4] = attValue.trim();
                    }
                    if (!attName2.equalsIgnoreCase("bundle")) continue;
                    themeAtts[5] = attValue.trim();
                }
                ThemesManagerImpl.this._theme = false;
                if (themeAtts[0] != null && ThemesManagerImpl.this._allMaps.containsKey(themeAtts[0])) {
                    ThemesManagerImpl.this._map = (Map)ThemesManagerImpl.this._allMaps.get(themeAtts[0]);
                    ThemesManagerImpl.this._directories = (Map)ThemesManagerImpl.this._map.get("directories");
                    ThemesManagerImpl.this._imageMap = (Map)ThemesManagerImpl.this._map.get("imageMap");
                    ThemesManagerImpl.this._styleMap = (Map)ThemesManagerImpl.this._map.get("styleMap");
                    ThemesManagerImpl.this._templateMap = (Map)ThemesManagerImpl.this._map.get("templateMap");
                } else {
                    ThemesManagerImpl.this._map = Collections.synchronizedMap(new HashMap());
                    ThemesManagerImpl.this._directories = new HashMap(3);
                    ThemesManagerImpl.this._imageMap = new HashMap();
                    ThemesManagerImpl.this._styleMap = new HashMap();
                    ThemesManagerImpl.this._templateMap = new HashMap();
                    ThemesManagerImpl.this._map.put("directories", ThemesManagerImpl.this._directories);
                    ThemesManagerImpl.this._map.put("imageMap", ThemesManagerImpl.this._imageMap);
                    ThemesManagerImpl.this._map.put("styleMap", ThemesManagerImpl.this._styleMap);
                    ThemesManagerImpl.this._map.put("templateMap", ThemesManagerImpl.this._templateMap);
                }
                ThemesManagerImpl.this._map.put("name", themeAtts[0]);
                ThemesManagerImpl.this._map.put("label", themeAtts[1]);
                ThemesManagerImpl.this._map.put("description", themeAtts[2]);
                ThemesManagerImpl.this._map.put("device", themeAtts[3]);
                ThemesManagerImpl.this._map.put("uripath", themeAtts[4]);
                ThemesManagerImpl.this._map.put("bundle", themeAtts[5]);
                if (this.urlPrefix != null) {
                    ThemesManagerImpl.this._map.put("URLprefix", this.urlPrefix);
                }
            }
            if (ThemesManagerImpl.this._styles) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("directory")) {
                        ThemesManagerImpl.this._directories.put("STYLE", attValue.trim());
                    }
                    ThemesManagerImpl.this._styles = false;
                }
            }
            if (ThemesManagerImpl.this._styleSheet) {
                ThemesManagerImpl.access$1302(ThemesManagerImpl.this, new String[5]);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("name")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._styleArray[0] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("description")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._styleArray[1] = attValue;
                    }
                    if (attName.equalsIgnoreCase("order")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._styleArray[2] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("media")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._styleArray[3] = attValue.trim();
                        if (ThemesManagerImpl.this._styleArray[3].equalsIgnoreCase("PRINTER")) {
                            ((ThemesManagerImpl)ThemesManagerImpl.this)._styleArray[3] = "PRINTER";
                        } else if (ThemesManagerImpl.this._styleArray[3].equalsIgnoreCase("SCREEN")) {
                            ((ThemesManagerImpl)ThemesManagerImpl.this)._styleArray[3] = "SCREEN";
                        }
                    }
                    if (!attName.equalsIgnoreCase("file")) continue;
                    ((ThemesManagerImpl)ThemesManagerImpl.this)._styleArray[4] = attValue.trim();
                }
                ThemesManagerImpl.this._styleSheet = false;
                ThemesManagerImpl.this._styleMap.put(ThemesManagerImpl.this._styleArray[0], ThemesManagerImpl.this._styleArray);
            }
            if (ThemesManagerImpl.this._images) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("directory")) {
                        ThemesManagerImpl.this._directories.put("IMAGE", attValue.trim());
                    }
                    ThemesManagerImpl.this._images = false;
                }
            }
            if (ThemesManagerImpl.this._image) {
                ThemesManagerImpl.access$1402(ThemesManagerImpl.this, new String[8]);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("name")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._imageArray[0] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("description")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._imageArray[1] = attValue;
                    }
                    if (attName.equalsIgnoreCase("path")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._imageArray[2] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("appliesTo")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._imageArray[3] = attValue.trim();
                        if (ThemesManagerImpl.this._imageArray[3] != null && ThemesManagerImpl.this._imageArray[3].equalsIgnoreCase("ALL")) {
                            ((ThemesManagerImpl)ThemesManagerImpl.this)._imageArray[3] = "ALL";
                        }
                    }
                    if (attName.equalsIgnoreCase("altTextKey")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._imageArray[4] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("width")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._imageArray[5] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("height")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._imageArray[6] = attValue.trim();
                    }
                    if (!attName.equalsIgnoreCase("file")) continue;
                    ((ThemesManagerImpl)ThemesManagerImpl.this)._imageArray[7] = attValue.trim();
                }
                ThemesManagerImpl.this._image = false;
                ThemesManagerImpl.this._imageMap.put(ThemesManagerImpl.this._imageArray[0], ThemesManagerImpl.this._imageArray);
            }
            if (ThemesManagerImpl.this._templates) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("directory")) {
                        ThemesManagerImpl.this._directories.put("TEMPLATE", attValue.trim());
                    }
                    ThemesManagerImpl.this._templates = false;
                }
            }
            if (ThemesManagerImpl.this._template) {
                ThemesManagerImpl.access$1502(ThemesManagerImpl.this, new String[4]);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("name")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._templateArray[0] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("description")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._templateArray[1] = attValue;
                    }
                    if (attName.equalsIgnoreCase("markup")) {
                        ((ThemesManagerImpl)ThemesManagerImpl.this)._templateArray[2] = attValue.trim();
                        if (ThemesManagerImpl.this._templateArray[2].equalsIgnoreCase("HTML")) {
                            ((ThemesManagerImpl)ThemesManagerImpl.this)._templateArray[2] = "HTML";
                        } else if (ThemesManagerImpl.this._templateArray[2].equalsIgnoreCase("WML")) {
                            ((ThemesManagerImpl)ThemesManagerImpl.this)._templateArray[2] = "WML";
                        } else if (ThemesManagerImpl.this._templateArray[2].equalsIgnoreCase("XML")) {
                            ((ThemesManagerImpl)ThemesManagerImpl.this)._templateArray[2] = "XML";
                        } else if (ThemesManagerImpl.this._templateArray[2].equalsIgnoreCase("CHTML")) {
                            ((ThemesManagerImpl)ThemesManagerImpl.this)._templateArray[2] = "CHTML";
                        }
                    }
                    if (!attName.equalsIgnoreCase("file")) continue;
                    ((ThemesManagerImpl)ThemesManagerImpl.this)._templateArray[3] = attValue.trim();
                }
                ThemesManagerImpl.this._template = false;
                ThemesManagerImpl.this._templateMap.put(ThemesManagerImpl.this._templateArray[0], ThemesManagerImpl.this._templateArray);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            if (namespaceURI == null || rawName != null) {
                // empty if block
            }
            if (localName.equalsIgnoreCase("theme")) {
                ThemesManagerImpl.this._theme = false;
                ThemesManagerImpl.this._allMaps.put(ThemesManagerImpl.this._map.get("name"), ThemesManagerImpl.this._map);
            }
            if (localName.equalsIgnoreCase("stylesheet")) {
                ThemesManagerImpl.this._styleSheet = false;
            }
            if (localName.equalsIgnoreCase("styles")) {
                ThemesManagerImpl.this._styles = false;
            }
            if (localName.equalsIgnoreCase("image")) {
                ThemesManagerImpl.this._image = false;
            }
            if (localName.equalsIgnoreCase("images")) {
                ThemesManagerImpl.this._images = false;
            }
            if (localName.equalsIgnoreCase("template")) {
                ThemesManagerImpl.this._template = false;
            }
            if (localName.equalsIgnoreCase("templates")) {
                ThemesManagerImpl.this._templates = false;
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (publicId == null || systemId != null) {
                // empty if block
            }
            InputSource retval = null;
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("com/sas/dtd/themes.dtd");
            retval = new InputSource(stream);
            return retval;
        }
    }
}

