/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.themes.components.impl;

import com.sas.common.util.ThemesRegistryInfo;
import com.sas.webapp.i18n.RB;
import com.sas.webapp.servlet.util.ServletUtil;
import com.sas.webapp.themes.ThemeException;
import com.sas.webapp.themes.components.ThemesManagerInitializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;

public class ThemesDescriptorFetcher
implements Runnable,
Serializable {
    private static final long serialVersionUID = -3356106099915711241L;
    private ThemesRegistryInfo _info;
    private int _maxTries;
    private int _sleepTime;
    private ThemesManagerInitializer _initializer;
    private Logger _logger;
    private static String _loggingContext = ThemesDescriptorFetcher.class.getName();
    private static String THEME_MAX_TRIES = "sas.theme.max.tries";

    public ThemesDescriptorFetcher(ThemesManagerInitializer factoryInitializer, ThemesRegistryInfo info, int maxTries, int sleepTime, Logger logger) {
        this._info = info;
        this._maxTries = maxTries;
        this._sleepTime = sleepTime;
        this._initializer = factoryInitializer;
        this._logger = logger;
        String maxTriesProp = System.getProperty(THEME_MAX_TRIES);
        if (maxTriesProp != null) {
            try {
                this._maxTries = Integer.parseInt(maxTriesProp);
            }
            catch (NumberFormatException e) {
                this._logger.error(e.getLocalizedMessage() + " " + THEME_MAX_TRIES + "=" + maxTriesProp, (Throwable)e);
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("maxTries is: " + this._maxTries);
            this._logger.debug("sleep time is: " + this._sleepTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String uri = this._info.getURI();
        String subnet = this._info.getSubnetToUse();
        BufferedReader bf = null;
        InputSource in = null;
        String startMsg = RB.getStringResource("ThemesFactory.startfile.fmt.txt");
        String finishMsg = RB.getStringResource("ThemesFactory.endfile.fmt.txt");
        if (uri != null) {
            try {
                StringBuffer baseURL = new StringBuffer().append(uri);
                baseURL.append("/themes/");
                String base = baseURL.toString();
                baseURL.append("ThemeXMLFiles.config");
                URL url = new URL(baseURL.toString());
                String baseFile = ServletUtil.readUrl(url, this._maxTries, this._sleepTime, subnet, this._logger, true);
                if (baseFile == null) {
                    return;
                }
                bf = new BufferedReader(new StringReader(baseFile));
                String line = bf.readLine();
                URL u = null;
                String body = null;
                while (line != null) {
                    u = new URL(base + line);
                    this._logger.info(MessageFormat.format(startMsg, u.toString()));
                    body = ServletUtil.readUrl(u, this._maxTries, this._sleepTime, subnet, this._logger, true);
                    if (body != null) {
                        in = new InputSource(new StringReader(body));
                        this._initializer.getThemesFactory().addThemeDef(in, this._info.getExternalURI());
                        this._logger.info(MessageFormat.format(finishMsg, u.toString()));
                    }
                    line = bf.readLine();
                }
            }
            catch (ThemeException e) {
                this.logError((Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                this.logError(e);
            }
            catch (UnknownHostException e) {
                this.logError(e);
            }
            catch (IOException e) {
                this.logError(e);
            }
            finally {
                this._initializer.initTaskComplete();
                if (bf != null) {
                    try {
                        bf.close();
                    }
                    catch (IOException e) {
                        this.logError(e);
                    }
                }
            }
        }
    }

    private void logError(Exception e) {
        this._logger.error(e.getLocalizedMessage(), (Throwable)e);
    }
}

