/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.themes;

import com.sas.services.user.UserContextInterface;
import com.sas.webapp.i18n.RB;
import com.sas.webapp.themes.DefaultThemesFactoryInitializer;
import com.sas.webapp.themes.Theme;
import com.sas.webapp.themes.ThemeException;
import com.sas.webapp.themes.ThemeInstanceException;
import com.sas.webapp.themes.ThemesFactoryInitializer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ThemesFactory
implements Serializable {
    static final long serialVersionUID = -8851409190275153566L;
    public static final String RB_KEY = "ThemesFactory.";
    public static final String SYSTEM_ID = "http://www.sas.com/webapp/themes.dtd";
    public static final String THEME_DTD_URL = "theme-descriptor-url";
    public static final int MAXIMUM_RETRIES_20 = 20;
    public static final int MAXIMUM_RETRIES_30 = 30;
    public static final int MAXIMUM_RETRIES_40 = 40;
    public static final int SLEEP_TIME_2000 = 2000;
    public static final int SLEEP_TIME_4000 = 4000;
    public static final int SLEEP_TIME_6000 = 6000;
    private boolean _styles = false;
    private boolean _styleSheet = false;
    private boolean _images = false;
    private boolean _image = false;
    private boolean _templates = false;
    private boolean _template = false;
    private boolean _theme = false;
    private String[] imageArray = null;
    private String[] styleArray = null;
    private String[] templateArray = null;
    private Map directories = null;
    private Map imageMap = null;
    private Map styleMap = null;
    private Map templateMap = null;
    private Map map = null;
    private Map allMaps = new Hashtable();
    private Map allThemes = new Hashtable();
    private static final String nullKey = "ThemesFactory.nullparameter.txt";
    public static final String XML_FILES_FILE_NAME = "ThemeXMLFiles.config";
    private static ThemesFactory tf = null;
    private transient ThemesFactoryInitializer _initializer;

    public static synchronized ThemesFactory getInstance(UserContextInterface userContext, ServletContext servletContext) throws ThemeException {
        if (servletContext != null) {
            // empty if block
        }
        if (tf == null) {
            ThemesFactory.initialize(userContext);
            if (tf.getThemeNames().isEmpty()) {
                throw new ThemeException(RB.getStringResource("ThemesFactory.nothemes.txt"));
            }
        } else if (!tf.isInitialized() && !tf.getInitializer().isRunning()) {
            try {
                tf.getInitializer().init();
                tf.getInitializer().waitForFinish();
            }
            catch (RemoteException e) {
                throw new ThemeException(e.getMessage());
            }
        }
        return tf;
    }

    public static synchronized ThemesFactory getInstance() throws ThemeInstanceException, ThemeException {
        if (tf == null || !tf.isInitialized()) {
            throw new ThemeInstanceException("com.sas.webapp.i18n.Resources", "ThemesFactory.init.progress.txt", null, ThemesFactory.class.getClassLoader());
        }
        if (!tf.isInitialized() && !tf.getInitializer().isRunning()) {
            try {
                tf.getInitializer().init();
                tf.getInitializer().waitForFinish();
            }
            catch (RemoteException e) {
                throw new ThemeException(e.getMessage());
            }
        }
        return tf;
    }

    public static synchronized void initialize(UserContextInterface userContext) throws ThemeException {
        ThemesFactory.initialize(userContext, 40, 4000, new DefaultThemesFactoryInitializer());
    }

    public static synchronized void initialize(UserContextInterface userContext, int maxTries, int sleepTime, ThemesFactoryInitializer initializer) throws ThemeException {
        if (tf != null) {
            return;
        }
        if (userContext == null) {
            throw new NullPointerException(RB.getStringResource(nullKey, Locale.getDefault()));
        }
        tf = new ThemesFactory();
        if (tf.getInitializer() == null) {
            initializer.setThemesFactory(tf, userContext);
            initializer.setParams(ThemesFactory.buildParams(userContext, maxTries, sleepTime));
            try {
                initializer.init();
            }
            catch (RemoteException e) {
                throw new ThemeException(e.getMessage());
            }
        }
    }

    private ThemesFactory() {
    }

    public ThemesFactory(Set set) throws ThemeException {
        if (set == null) {
            throw new NullPointerException(RB.getStringResource(nullKey, Locale.getDefault()));
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            InputSource source = new InputSource((InputStream)iter.next());
            this.addThemeDef(source);
        }
        this.finish();
    }

    public ThemesFactory(InputStream stream) throws ThemeException {
        if (stream == null) {
            throw new NullPointerException(RB.getStringResource(nullKey, Locale.getDefault()));
        }
        InputSource source = new InputSource(stream);
        this.addThemeDef(source);
        this.finish();
    }

    public ThemesFactory(String uri) throws ThemeException {
        if (uri == null) {
            throw new NullPointerException(RB.getStringResource(nullKey, Locale.getDefault()));
        }
        this.uriConstructors(uri);
    }

    public List getThemeNames() {
        List<Object> themeList = new ArrayList();
        themeList = Arrays.asList(this.allThemes.keySet().toArray());
        return themeList;
    }

    public Theme getTheme(String name) {
        return (Theme)this.allThemes.get(name);
    }

    public boolean isValidTheme(String name) {
        if (name == null) {
            throw new NullPointerException(RB.getStringResource(nullKey, Locale.getDefault()));
        }
        return this.allThemes.containsKey(name);
    }

    public boolean isInitialized() {
        boolean retval = false;
        if (this._initializer != null && this._initializer.isFinished()) {
            retval = true;
        }
        return retval;
    }

    public String getTranslationString(Locale aLocale, String themeName) {
        if (aLocale != null) {
            // empty if block
        }
        String retVal = null;
        Theme theme = this.getTheme(themeName);
        retVal = theme != null ? theme.getLabel() : "default";
        return retVal;
    }

    public List getListOfValidValues() {
        return this.getThemeNames();
    }

    private void addThemeDef(InputSource source) throws ThemeException {
        this.addThemeDef(source, null);
    }

    public synchronized void addThemeDef(InputSource source, String urlPrefix) throws ThemeException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            ContentDocumentHandler handler = new ContentDocumentHandler(urlPrefix);
            parser.parse(source, (DefaultHandler)handler);
            System.out.println("addThemeDef() parsed " + urlPrefix);
        }
        catch (FactoryConfigurationError fce) {
            System.err.println(fce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            ThemeException te = new ThemeException("ParserConfigurationException thrown in initialize().", pce);
            te.setMessage("com.sas.webapp.i18n.RB", "ThemesFactory.ParserConfigurationException.txt", null);
            throw te;
        }
        catch (SAXException se) {
            ThemeException te = new ThemeException("SAXException thrown in initialize().", se);
            te.setMessage("com.sas.webapp.i18n.Resources", "ThemesFactory.SAXException.txt", null);
            throw te;
        }
        catch (IOException ioe) {
            ThemeException te = new ThemeException("IOException thrown in initialize().", ioe);
            te.setMessage("com.sas.webapp.i18n.Resources", "ThemesFactory.IOException.txt", null);
            throw te;
        }
    }

    private void init(File dirName) throws ThemeException {
        File[] contentFiles = dirName.listFiles();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        InputSource source = null;
        int end = contentFiles.length;
        try {
            for (int i = 0; i < end; ++i) {
                File contentXML = contentFiles[i];
                if (contentXML.getName().endsWith("xml")) {
                    String uri = contentXML.getAbsolutePath();
                    fis = new FileInputStream(uri);
                    bis = new BufferedInputStream(fis);
                    source = new InputSource(bis);
                    this.addThemeDef(source);
                }
                if (i != end - 1) continue;
                this.finish();
            }
        }
        catch (IOException ioe) {
            ThemeException te = new ThemeException("IOException thrown in init().", ioe);
            te.setMessage("com.sas.webapp.i18n.Resources", "ThemesFactory.IOException.txt", null);
            throw te;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ioe) {
                ThemeException te = new ThemeException("IOException thrown in initialize().", ioe);
                te.setMessage("com.sas.webapp.i18n.Resources", "ThemesFactory.IOException.txt", null);
                throw te;
            }
        }
    }

    public void finish() {
        Collection coll = this.allMaps.values();
        Iterator it = coll.iterator();
        Theme theme = null;
        while (it.hasNext()) {
            theme = new Theme((Map)it.next());
            this.allThemes.put(theme.getName(), theme);
        }
        System.out.println(this.toString());
    }

    private void uriConstructors(String uri) throws ThemeException {
        File dirName = new File(uri);
        if (dirName.isDirectory()) {
            this.init(dirName);
        } else {
            InputSource source = new InputSource(uri);
            this.addThemeDef(source);
            this.finish();
        }
    }

    private static Map buildParams(UserContextInterface user, int maxTries, int sleep) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("metadataUser", user);
        retval.put("maxRetries", String.valueOf(maxTries));
        retval.put("retryPause", String.valueOf(sleep));
        retval.put("socketTimeout", String.valueOf(30000));
        return retval;
    }

    ThemesFactoryInitializer getInitializer() {
        return this._initializer;
    }

    void setInitializer(ThemesFactoryInitializer initializer) {
        this._initializer = initializer;
    }

    public static void destroy() {
    }

    public String toString() {
        return "Theme names and labels: " + this.allThemes.toString();
    }

    static /* synthetic */ String[] access$1302(ThemesFactory x0, String[] x1) {
        x0.styleArray = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1402(ThemesFactory x0, String[] x1) {
        x0.imageArray = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1502(ThemesFactory x0, String[] x1) {
        x0.templateArray = x1;
        return x1;
    }

    private class ContentDocumentHandler
    extends DefaultHandler {
        String urlPrefix;

        ContentDocumentHandler(String urlPrefix) {
            this.urlPrefix = urlPrefix;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            String attName;
            if (namespaceURI == null || rawName != null) {
                // empty if block
            }
            if (localName.equalsIgnoreCase("theme")) {
                ThemesFactory.this._theme = true;
            }
            if (localName.equalsIgnoreCase("styles")) {
                ThemesFactory.this._styles = true;
            }
            if (localName.equalsIgnoreCase("stylesheet")) {
                ThemesFactory.this._styleSheet = true;
            }
            if (localName.equalsIgnoreCase("images")) {
                ThemesFactory.this._images = true;
            }
            if (localName.equalsIgnoreCase("image")) {
                ThemesFactory.this._image = true;
            }
            if (localName.equalsIgnoreCase("templates")) {
                ThemesFactory.this._templates = true;
            }
            if (localName.equalsIgnoreCase("template")) {
                ThemesFactory.this._template = true;
            }
            if (ThemesFactory.this._theme) {
                String[] themeAtts = new String[7];
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    String attName2 = atts.getLocalName(i);
                    if (attName2.equalsIgnoreCase("name")) {
                        themeAtts[0] = attValue.trim();
                    }
                    if (attName2.equalsIgnoreCase("label")) {
                        themeAtts[1] = attValue.trim();
                    }
                    if (attName2.equalsIgnoreCase("description")) {
                        themeAtts[2] = attValue.trim();
                    }
                    if (attName2.equalsIgnoreCase("device")) {
                        themeAtts[3] = attValue.trim();
                    }
                    if (attName2.equalsIgnoreCase("URIPath")) {
                        themeAtts[4] = attValue.trim();
                    }
                    if (attName2.equalsIgnoreCase("bundle")) {
                        themeAtts[5] = attValue.trim();
                    }
                    if (!attName2.equalsIgnoreCase("version")) continue;
                    themeAtts[6] = attValue.trim();
                }
                ThemesFactory.this._theme = false;
                if (ThemesFactory.this.allMaps.containsKey(themeAtts[0])) {
                    ThemesFactory.this.map = (Map)ThemesFactory.this.allMaps.get(themeAtts[0]);
                    ThemesFactory.this.directories = (Map)ThemesFactory.this.map.get("directories");
                    ThemesFactory.this.imageMap = (Map)ThemesFactory.this.map.get("imageMap");
                    ThemesFactory.this.styleMap = (Map)ThemesFactory.this.map.get("styleMap");
                    ThemesFactory.this.templateMap = (Map)ThemesFactory.this.map.get("templateMap");
                } else {
                    ThemesFactory.this.map = Collections.synchronizedMap(new HashMap());
                    ThemesFactory.this.directories = new HashMap(3);
                    ThemesFactory.this.imageMap = new HashMap();
                    ThemesFactory.this.styleMap = new HashMap();
                    ThemesFactory.this.templateMap = new HashMap();
                    ThemesFactory.this.map.put("directories", ThemesFactory.this.directories);
                    ThemesFactory.this.map.put("imageMap", ThemesFactory.this.imageMap);
                    ThemesFactory.this.map.put("styleMap", ThemesFactory.this.styleMap);
                    ThemesFactory.this.map.put("templateMap", ThemesFactory.this.templateMap);
                }
                ThemesFactory.this.map.put("name", themeAtts[0]);
                ThemesFactory.this.map.put("label", themeAtts[1]);
                ThemesFactory.this.map.put("description", themeAtts[2]);
                ThemesFactory.this.map.put("device", themeAtts[3]);
                ThemesFactory.this.map.put("uripath", themeAtts[4]);
                ThemesFactory.this.map.put("bundle", themeAtts[5]);
                ThemesFactory.this.map.put("version", themeAtts[6]);
                if (this.urlPrefix != null) {
                    ThemesFactory.this.map.put("URLprefix", this.urlPrefix);
                }
            }
            if (ThemesFactory.this._styles) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("directory")) {
                        ThemesFactory.this.directories.put("STYLE", attValue.trim());
                    }
                    ThemesFactory.this._styles = false;
                }
            }
            if (ThemesFactory.this._styleSheet) {
                ThemesFactory.access$1302(ThemesFactory.this, new String[5]);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("name")) {
                        ((ThemesFactory)ThemesFactory.this).styleArray[0] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("description")) {
                        ((ThemesFactory)ThemesFactory.this).styleArray[1] = attValue;
                    }
                    if (attName.equalsIgnoreCase("order")) {
                        ((ThemesFactory)ThemesFactory.this).styleArray[2] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("media")) {
                        ((ThemesFactory)ThemesFactory.this).styleArray[3] = attValue.trim();
                        if (ThemesFactory.this.styleArray[3].equalsIgnoreCase("PRINTER")) {
                            ((ThemesFactory)ThemesFactory.this).styleArray[3] = "PRINTER";
                        } else if (ThemesFactory.this.styleArray[3].equalsIgnoreCase("SCREEN")) {
                            ((ThemesFactory)ThemesFactory.this).styleArray[3] = "SCREEN";
                        }
                    }
                    if (!attName.equalsIgnoreCase("file")) continue;
                    ((ThemesFactory)ThemesFactory.this).styleArray[4] = attValue.trim();
                }
                ThemesFactory.this._styleSheet = false;
                ThemesFactory.this.styleMap.put(ThemesFactory.this.styleArray[0], ThemesFactory.this.styleArray);
            }
            if (ThemesFactory.this._images) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("directory")) {
                        ThemesFactory.this.directories.put("IMAGE", attValue.trim());
                    }
                    ThemesFactory.this._images = false;
                }
            }
            if (ThemesFactory.this._image) {
                ThemesFactory.access$1402(ThemesFactory.this, new String[8]);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("name")) {
                        ((ThemesFactory)ThemesFactory.this).imageArray[0] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("description")) {
                        ((ThemesFactory)ThemesFactory.this).imageArray[1] = attValue;
                    }
                    if (attName.equalsIgnoreCase("path")) {
                        ((ThemesFactory)ThemesFactory.this).imageArray[2] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("appliesTo")) {
                        ((ThemesFactory)ThemesFactory.this).imageArray[3] = attValue.trim();
                        if (ThemesFactory.this.imageArray[3].equalsIgnoreCase("ALL")) {
                            ((ThemesFactory)ThemesFactory.this).imageArray[3] = "ALL";
                        }
                    }
                    if (attName.equalsIgnoreCase("altTextKey")) {
                        ((ThemesFactory)ThemesFactory.this).imageArray[4] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("width")) {
                        ((ThemesFactory)ThemesFactory.this).imageArray[5] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("height")) {
                        ((ThemesFactory)ThemesFactory.this).imageArray[6] = attValue.trim();
                    }
                    if (!attName.equalsIgnoreCase("file")) continue;
                    ((ThemesFactory)ThemesFactory.this).imageArray[7] = attValue.trim();
                }
                ThemesFactory.this._image = false;
                ThemesFactory.this.imageMap.put(ThemesFactory.this.imageArray[0], ThemesFactory.this.imageArray);
            }
            if (ThemesFactory.this._templates) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("directory")) {
                        ThemesFactory.this.directories.put("TEMPLATE", attValue.trim());
                    }
                    ThemesFactory.this._templates = false;
                }
            }
            if (ThemesFactory.this._template) {
                ThemesFactory.access$1502(ThemesFactory.this, new String[4]);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attValue = atts.getValue(i);
                    attName = atts.getLocalName(i);
                    if (attName.equalsIgnoreCase("name")) {
                        ((ThemesFactory)ThemesFactory.this).templateArray[0] = attValue.trim();
                    }
                    if (attName.equalsIgnoreCase("description")) {
                        ((ThemesFactory)ThemesFactory.this).templateArray[1] = attValue;
                    }
                    if (attName.equalsIgnoreCase("markup")) {
                        ((ThemesFactory)ThemesFactory.this).templateArray[2] = attValue.trim();
                        if (ThemesFactory.this.templateArray[2].equalsIgnoreCase("HTML")) {
                            ((ThemesFactory)ThemesFactory.this).templateArray[2] = "HTML";
                        } else if (ThemesFactory.this.templateArray[2].equalsIgnoreCase("WML")) {
                            ((ThemesFactory)ThemesFactory.this).templateArray[2] = "WML";
                        } else if (ThemesFactory.this.templateArray[2].equalsIgnoreCase("XML")) {
                            ((ThemesFactory)ThemesFactory.this).templateArray[2] = "XML";
                        } else if (ThemesFactory.this.templateArray[2].equalsIgnoreCase("CHTML")) {
                            ((ThemesFactory)ThemesFactory.this).templateArray[2] = "CHTML";
                        }
                    }
                    if (!attName.equalsIgnoreCase("file")) continue;
                    ((ThemesFactory)ThemesFactory.this).templateArray[3] = attValue.trim();
                }
                ThemesFactory.this._template = false;
                ThemesFactory.this.templateMap.put(ThemesFactory.this.templateArray[0], ThemesFactory.this.templateArray);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            if (namespaceURI == null || rawName != null) {
                // empty if block
            }
            if (localName.equalsIgnoreCase("theme")) {
                ThemesFactory.this._theme = false;
                ThemesFactory.this.allMaps.put(ThemesFactory.this.map.get("name"), ThemesFactory.this.map);
            }
            if (localName.equalsIgnoreCase("stylesheet")) {
                ThemesFactory.this._styleSheet = false;
            }
            if (localName.equalsIgnoreCase("styles")) {
                ThemesFactory.this._styles = false;
            }
            if (localName.equalsIgnoreCase("image")) {
                ThemesFactory.this._image = false;
            }
            if (localName.equalsIgnoreCase("images")) {
                ThemesFactory.this._images = false;
            }
            if (localName.equalsIgnoreCase("template")) {
                ThemesFactory.this._template = false;
            }
            if (localName.equalsIgnoreCase("templates")) {
                ThemesFactory.this._templates = false;
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (publicId == null || systemId != null) {
                // empty if block
            }
            InputSource retval = null;
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("com/sas/dtd/themes.dtd");
            retval = new InputSource(stream);
            return retval;
        }
    }
}

