/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.servlet.util;

import com.sas.webapp.i18n.RB;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipUtil {
    public static final String RB_KEY = "ZipUtil.";

    public static Set getStreamsFromFiles(URL url, String path, String fileType) throws IOException {
        ZipUtil.checkForNull(url);
        ZipUtil.checkForNull(path);
        ZipUtil.checkForNull(fileType);
        if (!url.toExternalForm().startsWith("zip:")) {
            throw new IllegalArgumentException(RB.getStringResource("ZipUtil.badurl.txt", Locale.getDefault()));
        }
        HashSet<InputStream> set = new HashSet<InputStream>(4);
        String zipFilename = url.getPath().replaceAll("!" + path, "");
        ZipFile zipFile = new ZipFile(zipFilename);
        Enumeration<? extends ZipEntry> enumerator = zipFile.entries();
        String tempPath = null;
        tempPath = path.startsWith("/") ? path.substring(1) : path;
        while (enumerator.hasMoreElements()) {
            ZipEntry entry = enumerator.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(tempPath) || !entryName.endsWith(fileType) || entryName.indexOf("/") != entryName.lastIndexOf("/") || entry.isDirectory()) continue;
            set.add(zipFile.getInputStream(entry));
        }
        return set;
    }

    private static void checkForNull(Object param) {
        if (param == null) {
            throw new NullPointerException(RB.getStringResource("ZipUtil.nullparameter.txt", Locale.getDefault()));
        }
    }
}

