/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.servlet.util;

import com.sas.common.util.MetadataUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.information.metadata.TCPIPConnectionInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.webapp.i18n.RB;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class PrefURLUtil
implements Serializable {
    static final long serialVersionUID = -5243028208626640834L;
    private static String _preferencesURL;
    private static final String RB_KEY = "PrefURLUtil.";

    private PrefURLUtil() {
    }

    public static String getURL(UserContextInterface userContext) throws RemoteException, ServiceException {
        if (_preferencesURL == null) {
            PrefURLUtil.checkForNull(userContext, "userContext");
            _preferencesURL = PrefURLUtil.getURLFromMetadata(userContext);
        }
        return _preferencesURL;
    }

    private static String getURLFromMetadata(UserContextInterface userContext) throws RemoteException, ServiceException {
        Filter filter = new Filter("Name", 0, "SASPreferences");
        filter.setType("SoftwareComponent");
        filter.setOMRFlags(8704);
        List list = MetadataUtil.find((UserContextInterface)userContext, (FilterInterface)filter);
        if (list.size() == 0) {
            String msg = RB.getStringResource("PrefURLUtil.missing.software.component.txt", Locale.getDefault());
            throw new ServiceException(msg);
        }
        String retval = null;
        SoftwareComponentInterface sc = (SoftwareComponentInterface)list.get(0);
        try {
            Object obj;
            ServerInterface dc;
            Iterator itConn;
            Iterator itDeployed = sc.getDeployedComponents().iterator();
            if (itDeployed.hasNext() && (itConn = (dc = (ServerInterface)(obj = itDeployed.next())).getSourceConnections().iterator()).hasNext()) {
                Object sourceConn = itConn.next();
                TCPIPConnectionInterface tcpip = (TCPIPConnectionInterface)sourceConn;
                String commProtocol = tcpip.getCommunicationProtocol();
                String hostName = tcpip.getHost();
                int hostPort = tcpip.getPort();
                if (hostName != null && hostName.trim().length() > 0) {
                    retval = commProtocol + "://" + hostName + ":" + hostPort;
                    System.out.println("Using specific machine and port for preferences web application");
                } else {
                    System.out.println("Using relative location for preferencs web application");
                    retval = "";
                }
                retval = retval + tcpip.getService();
            }
        }
        catch (ServiceException m) {
            throw new RemoteException(m.getMessage(), m);
        }
        return retval;
    }

    private static void checkForNull(Object param, String name) {
        if (param == null) {
            throw new NullPointerException(MessageFormat.format(RB.getStringResource("general.nullparameter.fmt"), name));
        }
    }
}

