/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.servlet.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FileCache {
    private static final long MAX_AGE = 300000L;
    private Map _files = new Hashtable();

    public void addFile(String name, String file) {
        FileCacheEntry fce = new FileCacheEntry();
        fce.name = name;
        fce.contents = file;
        fce.createTime = System.currentTimeMillis();
        this._files.put(name, fce);
    }

    public String findFile(String name) {
        String retval = null;
        FileCacheEntry fce = (FileCacheEntry)this._files.get(name);
        if (fce != null) {
            retval = fce.contents;
        }
        return retval;
    }

    class CacheReaper
    implements Runnable {
        private Map _cache;
        private List _entryKeys = new Vector();

        public CacheReaper(Map cache) {
            this._cache = cache;
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ArrayList keysSnapshot = new ArrayList();
                keysSnapshot.addAll(this._entryKeys);
                long currentTime = System.currentTimeMillis();
                Iterator iter = keysSnapshot.iterator();
                while (true) {
                    if (!iter.hasNext()) continue block2;
                    String key = (String)iter.next();
                    FileCacheEntry fce = (FileCacheEntry)this._cache.get(key);
                    if (fce == null || currentTime - fce.createTime <= 300000L) continue;
                    this._entryKeys.remove(key);
                    this._cache.remove(key);
                }
                break;
            }
        }

        public void addEntry(String entry) {
            this._entryKeys.add(entry);
        }
    }

    class FileCacheEntry {
        String name;
        String contents;
        long createTime;

        FileCacheEntry() {
        }
    }
}

