/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.servlet.filters;

import com.sas.midtier.components.container.decorators.TimingProxy;
import com.sas.midtier.components.container.util.impl.ComponentsUtil;
import com.sas.webapp.components.configuration.ApplicationConfiguration;
import com.sas.webapp.servlet.filters.HttpFilterInterface;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpFilter
implements Filter,
HttpFilterInterface {
    private HttpFilterInterface _timingHandler = null;
    private static final String FILTER_LIST = "FilterList";
    private String _filterName;
    protected ServletContext _servletContext;

    public void init(FilterConfig config) throws ServletException {
        this._filterName = config.getFilterName();
        this._servletContext = config.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this._timingHandler == null) {
            String enabledStr;
            Map config;
            ApplicationConfiguration appConfig = (ApplicationConfiguration)this.getComponent(ApplicationConfiguration.class);
            if (appConfig != null && (config = appConfig.getMap("filterTiming")) != null && (enabledStr = (String)config.get("enable")) != null && Boolean.valueOf(enabledStr).booleanValue()) {
                TimingProxy proxy = new TimingProxy((Object)this, config);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?>[] allClasses = HttpFilter.class.getInterfaces();
                if (allClasses.length > 0) {
                    this._timingHandler = (HttpFilterInterface)Proxy.newProxyInstance(classLoader, allClasses, (InvocationHandler)proxy);
                }
            }
            if (this._timingHandler == null) {
                this._timingHandler = this;
            }
        }
        HttpServletRequest webRequest = (HttpServletRequest)request;
        HttpServletResponse webResponse = (HttpServletResponse)response;
        this._timingHandler.doFilter(webRequest, webResponse, chain);
    }

    @Override
    public abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;

    public void destroy() {
    }

    public boolean hasProcessed(HttpServletRequest request) {
        boolean processed;
        ArrayList filterList = (ArrayList)request.getAttribute(FILTER_LIST);
        boolean bl = processed = filterList != null && filterList.indexOf(this._filterName) > -1;
        if (!processed) {
            this.markProcessed(request);
        }
        return processed;
    }

    protected Object getComponent(Class componentClass) {
        return ComponentsUtil.locateComponent((Class)componentClass, (ServletContext)this._servletContext);
    }

    private void markProcessed(HttpServletRequest request) {
        ArrayList<String> filterList = (ArrayList<String>)request.getAttribute(FILTER_LIST);
        if (filterList == null) {
            filterList = new ArrayList<String>();
            request.setAttribute(FILTER_LIST, filterList);
        }
        filterList.add(this._filterName);
    }
}

