/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.remote.session;

import com.sas.webapp.remote.session.RootSessionDestructionListener;
import com.sas.webapp.remote.session.SessionFactory;

public class SessionHarvester
implements Runnable {
    private static final long THREAD_WAIT = 300000L;
    private RootSessionDestructionListener _listener;
    private boolean _isStopped;
    private long _eventTimeout;
    private long _sessionTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._isStopped) {
            boolean harvest = false;
            harvest = this._listener == null ? true : this.evaluateEventTimeout();
            if (harvest) {
                this.harvestSessions();
            }
            SessionHarvester sessionHarvester = this;
            synchronized (sessionHarvester) {
                try {
                    this.wait(300000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public RootSessionDestructionListener getListener() {
        return this._listener;
    }

    public void setListener(RootSessionDestructionListener listener) {
        this._listener = listener;
    }

    public synchronized void isStopped(boolean stopped) {
        this._isStopped = stopped;
        if (this._isStopped) {
            this.notify();
        }
    }

    public boolean isStopped() {
        return this._isStopped;
    }

    private boolean evaluateEventTimeout() {
        long lastMessageElapsedTime = System.currentTimeMillis() - this._listener.getLastMessageReceived();
        return lastMessageElapsedTime > this._eventTimeout;
    }

    private void harvestSessions() {
        SessionFactory.getInstance().harvestSessions(this._sessionTimeout);
    }

    public long getEventTimeout() {
        return this._eventTimeout;
    }

    public long getSessionTimeout() {
        return this._sessionTimeout;
    }

    public void setEventTimeout(long timeout) {
        this._eventTimeout = timeout * 60000L;
    }

    public void setSessionTimeout(long timeout) {
        this._sessionTimeout = timeout;
    }
}

