/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.remote.session;

import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.events.EventFactory;
import com.sas.services.events.EventInterface;
import com.sas.services.events.broker.EventBrokerServiceInterface;
import com.sas.services.webapp.ServicesFacade;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class RootSessionDestructionSender
implements HttpSessionListener {
    private EventFactory _eventFactory = new EventFactory();
    private String _hostName;

    public void sessionCreated(HttpSessionEvent event) {
        if (event != null) {
            // empty if block
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        try {
            if (this._hostName == null) {
                this.resolveHostName();
            }
            EventBrokerServiceInterface eventService = ServicesFacade.getRemoteEventBrokerService();
            StringBuffer buf = new StringBuffer();
            buf.append("saspfs_http_root_session_id").append("=");
            buf.append(event.getSession().getId());
            buf.append("\n");
            buf.append("saspfs_http_root_session_host").append("=");
            buf.append(this._hostName);
            EventInterface destroyEvent = this._eventFactory.newEvent("sas.http.root.session.event");
            destroyEvent.setBody(buf.toString());
            String eventAsText = destroyEvent.serialize(0).toString();
            eventService.sendSyncEvent(eventAsText);
        }
        catch (InitializationException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    private synchronized void resolveHostName() throws UnknownHostException {
        if (this._hostName != null) {
            return;
        }
        this._hostName = InetAddress.getLocalHost().getCanonicalHostName();
    }
}

