/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.remote.session;

import com.sas.services.events.broker.ListenerInterface;
import com.sas.services.events.broker.MessageBodyConversionException;
import com.sas.services.events.broker.MessageInterface;
import com.sas.services.events.broker.flowengine.ResponseHandlerInterface;
import com.sas.webapp.remote.session.SessionFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Properties;
import javax.servlet.http.HttpSession;

public abstract class RootSessionDestructionListener
extends UnicastRemoteObject
implements ListenerInterface,
Unreferenced {
    private long _lastMessageRecvd = 0L;

    public long getLastMessageReceived() {
        return this._lastMessageRecvd;
    }

    public final void handleEvent(MessageInterface msg, ResponseHandlerInterface response) throws RemoteException {
        if (response != null) {
            // empty if block
        }
        this._lastMessageRecvd = System.currentTimeMillis();
        String body = null;
        if (!msg.getEventName().equals("sas.http.root.session.event")) {
            return;
        }
        try {
            body = msg.getBodyAsString();
        }
        catch (MessageBodyConversionException e) {
            return;
        }
        ByteArrayInputStream bodyStream = new ByteArrayInputStream(body.getBytes());
        Properties props = new Properties();
        try {
            props.load(bodyStream);
        }
        catch (IOException e) {
            return;
        }
        String rootSessionHost = props.getProperty("saspfs_http_root_session_host");
        String rootSessionId = props.getProperty("saspfs_http_root_session_id");
        HttpSession session = SessionFactory.getInstance().invalidateSession(rootSessionHost, rootSessionId);
        if (session != null) {
            this.sessionInvalidated(session);
        }
    }

    public abstract void sessionInvalidated(HttpSession var1);

    @Override
    public void unreferenced() {
    }
}

