/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.remote.session;

import com.sas.webapp.remote.session.SessionFactory;
import com.sas.webapp.remote.session.SessionUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class RemoteHttpSession
implements HttpSession {
    private long _createTime;
    private long _lastAccessedTime;
    private String _rootSessionId;
    private String _rootHost;
    private String _id;
    private Hashtable _attributes = new Hashtable();
    private ServletContext _servletContext;
    private boolean _isValid = true;

    public long getCreationTime() {
        return this._createTime;
    }

    public String getId() {
        return this._id;
    }

    public long getLastAccessedTime() {
        return this._lastAccessedTime;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setServletContext(ServletContext context) {
        this._servletContext = context;
    }

    public void setMaxInactiveInterval(int arg0) {
        if (arg0 != 0) {
            // empty if block
        }
    }

    public int getMaxInactiveInterval() {
        return -1;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String key) {
        this._lastAccessedTime = System.currentTimeMillis();
        return this._attributes.get(key);
    }

    public Object getValue(String key) {
        this._lastAccessedTime = System.currentTimeMillis();
        return this.getAttribute(key);
    }

    public Enumeration getAttributeNames() {
        this._lastAccessedTime = System.currentTimeMillis();
        return this._attributes.keys();
    }

    public String[] getValueNames() {
        this._lastAccessedTime = System.currentTimeMillis();
        String[] retval = null;
        Set keys = this._attributes.keySet();
        if (keys != null && keys.size() > 0) {
            retval = new String[keys.size()];
            int x = 0;
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                retval[x] = (String)iter.next();
                ++x;
            }
        }
        return retval;
    }

    public void setAttribute(String key, Object value) {
        this._lastAccessedTime = System.currentTimeMillis();
        HttpSessionBindingListener listener = SessionUtil.createListener(value);
        if (value == null) {
            this.removeAttribute(key);
        } else if (listener == null) {
            this._attributes.put(key, value);
        } else if (this._attributes.contains(key)) {
            Object previousValue = this._attributes.get(key);
            HttpSessionBindingListener previousListener = SessionUtil.createListener(previousValue);
            this.replaceAttributeWithEvent(key, value, previousValue, listener, previousListener);
        } else {
            this.addAttributeWithEvent(key, value, listener);
        }
    }

    public void putValue(String key, Object value) {
        this._lastAccessedTime = System.currentTimeMillis();
        this.setAttribute(key, value);
    }

    public void removeAttribute(String key) {
        this._lastAccessedTime = System.currentTimeMillis();
        Object value = this._attributes.get(key);
        HttpSessionBindingListener listener = SessionUtil.createListener(value);
        if (listener != null) {
            this.removeAttributeWithEvent(key, value, listener);
        } else {
            this._attributes.remove(key);
        }
    }

    public void removeValue(String key) {
        this._lastAccessedTime = System.currentTimeMillis();
        this.removeAttribute(key);
    }

    public void invalidate() {
        SessionFactory.getInstance().invalidateSession(this.getRootHost(), this.getRootSessionId());
        this._isValid = false;
    }

    public boolean isNew() {
        return this._lastAccessedTime == this._createTime;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public void setCreateTime(long l) {
        this._createTime = l;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setLastAccessedTime(long l) {
        this._lastAccessedTime = l;
    }

    public String getRootHost() {
        return this._rootHost;
    }

    public String getRootSessionId() {
        return this._rootSessionId;
    }

    public void setRootHost(String host) {
        this._rootHost = host;
    }

    public void setRootSessionId(String rootSessionId) {
        this._rootSessionId = rootSessionId;
    }

    boolean isValid() {
        return this._isValid;
    }

    private void removeAttributeWithEvent(String key, Object value, HttpSessionBindingListener listener) {
        this._attributes.remove(key);
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
        if (listener != null) {
            listener.valueUnbound(event);
        }
    }

    private void addAttributeWithEvent(String key, Object value, HttpSessionBindingListener listener) {
        this._attributes.put(key, value);
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
        if (listener != null) {
            listener.valueBound(event);
        }
    }

    private void replaceAttributeWithEvent(String key, Object value, Object previousValue, HttpSessionBindingListener listener, HttpSessionBindingListener previousListener) {
        this._attributes.put(key, value);
        HttpSessionBindingEvent replaceEvent = new HttpSessionBindingEvent((HttpSession)this, key, previousValue);
        HttpSessionBindingEvent addEvent = new HttpSessionBindingEvent((HttpSession)this, key, value);
        if (previousListener != null) {
            previousListener.valueUnbound(replaceEvent);
        }
        if (listener != null) {
            listener.valueBound(addEvent);
        }
    }
}

