/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.input.screening;

import com.sas.webapp.input.screening.ConfigurableScreeningProxy;
import com.sas.webapp.input.screening.Screenable;
import com.sas.webapp.input.screening.ScreeningProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScreenUtils {
    public static boolean isScreenable(Object target) {
        boolean retval = false;
        if (target != null) {
            retval = ScreenUtils.isScreenable(target.getClass());
        }
        return retval;
    }

    public static boolean isScreenable(Class klass) {
        boolean retval = false;
        retval = Screenable.class.isAssignableFrom(klass);
        return retval;
    }

    public static Object createScreeningProxy(Object target) {
        ClassLoader cl = target.getClass().getClassLoader();
        Class[] interfaces = target.getClass().getInterfaces();
        return ScreenUtils.createScreeningProxy(cl, interfaces, target);
    }

    public static Object createScreeningProxy(Object target, Map config) {
        ClassLoader cl = target.getClass().getClassLoader();
        Class[] interfaces = target.getClass().getInterfaces();
        return ScreenUtils.createScreeningProxy(cl, interfaces, target, config);
    }

    public static Object createScreeningProxy(List list) {
        ArrayList<Object> retval = null;
        if (list != null) {
            retval = new ArrayList<Object>();
            for (Object item : list) {
                if (ScreenUtils.isScreenable(item)) {
                    retval.add(ScreenUtils.createScreeningProxy(item));
                    continue;
                }
                retval.add(item);
            }
        }
        return retval;
    }

    public static Object createScreeningProxy(ClassLoader classLoader, Class[] interfaces, Object target) {
        Object proxy = null;
        if (interfaces != null && interfaces.length > 0 && ScreenUtils.isScreenable(target)) {
            proxy = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ScreeningProxy(target));
        }
        return proxy;
    }

    public static Object createScreeningProxy(ClassLoader classLoader, Class[] interfaces, Object target, Map config) {
        Object proxy = null;
        if (interfaces != null && interfaces.length > 0 && ScreenUtils.isScreenable(target)) {
            proxy = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ConfigurableScreeningProxy(target, config));
        }
        return proxy;
    }

    private ScreenUtils() {
    }
}

