/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.contextsharing;

import com.sas.codepolicy.SASScope;
import com.sas.midtier.components.container.util.impl.ComponentsUtil;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.webapp.ServicesFacade;
import com.sas.webapp.components.services.ServicesManager;
import com.sas.webapp.contextsharing.RequestActionMenuData;
import com.sas.webapp.contextsharing.WebappContextParamsCleanupInterface;
import com.sas.webapp.i18n.RB;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@SASScope(value="ALL")
public class WebappContextParams {
    private SessionContextInterface _sessionContext = null;
    private String _sessionId = null;
    private String _startURL = null;
    private String _url = null;
    private Map _requestParams = null;
    private String _sessionRequestId = null;
    private String _portletid = null;
    private boolean _receiver = false;
    private boolean _shouldReceiverDestroyWACP = true;

    public WebappContextParams(SessionContextInterface sessionContext, String url, boolean shouldReceiverDestroyWACP) throws RemoteException {
        this._sessionContext = sessionContext;
        this._sessionId = this._sessionContext.getEntityKey();
        this._startURL = url;
        this._receiver = false;
        this._shouldReceiverDestroyWACP = shouldReceiverDestroyWACP;
    }

    public WebappContextParams(SessionContextInterface sessionContext, String url) throws RemoteException {
        this(sessionContext, url, true);
    }

    public WebappContextParams(SessionContextInterface sessionContext) throws RemoteException {
        this(sessionContext, "", true);
    }

    public WebappContextParams(UserContextInterface user, HttpServletRequest request) throws InitializationException, RemoteException, ServiceException {
        this(user, request, true);
    }

    public WebappContextParams(UserContextInterface user, HttpServletRequest request, boolean useRemoteServices) throws InitializationException, RemoteException, ServiceException {
        this._sessionId = request.getParameter("saspfs_sessionid");
        SessionServiceInterface sessionService = null;
        ServicesManager servicesManager = (ServicesManager)ComponentsUtil.locateComponent(ServicesManager.class, (HttpServletRequest)request);
        if (servicesManager != null) {
            sessionService = useRemoteServices ? servicesManager.getRemoteSessionService() : servicesManager.getSessionService();
            this._sessionContext = WebappContextParams.getSessionContext(user, this._sessionId, sessionService);
        } else {
            this._sessionContext = WebappContextParams.getSessionContext(user, this._sessionId, useRemoteServices);
        }
        if (this._sessionContext == null) {
            throw new InitializationException(RB.getStringResource("WebappContextParams.NoSessionContext.txt"));
        }
        this._sessionRequestId = request.getParameter("saspfs_sessionrequest");
        if (this._sessionRequestId != null) {
            this._requestParams = (Map)this._sessionContext.getAttribute(this._sessionRequestId);
            if (this._requestParams == null) {
                this._requestParams = (Map)request.getAttribute("saspfs_sessionrequest");
            } else {
                this._sessionContext.removeAttribute(this._sessionRequestId);
            }
        }
        this._portletid = request.getParameter("sasportal_portletid");
        this._startURL = "";
        this._receiver = true;
    }

    public WebappContextParams(UserContextInterface user, HttpServletRequest request, ServicesManager servicesManager) throws InitializationException, RemoteException, ServiceException {
        this._sessionId = request.getParameter("saspfs_sessionid");
        if (servicesManager == null) {
            servicesManager = (ServicesManager)ComponentsUtil.locateComponent(ServicesManager.class, (HttpServletRequest)request);
        }
        SessionServiceInterface remoteSessionService = servicesManager.getRemoteSessionService();
        this._sessionContext = WebappContextParams.getSessionContext(user, this._sessionId, remoteSessionService);
        this._sessionRequestId = request.getParameter("saspfs_sessionrequest");
        if (this._sessionRequestId != null) {
            this._requestParams = (Map)this._sessionContext.getAttribute(this._sessionRequestId);
            this._sessionContext.removeAttribute(this._sessionRequestId);
        }
        this._portletid = request.getParameter("sasportal_portletid");
        this._startURL = "";
        this._receiver = true;
    }

    public void term() throws RemoteException {
        if (!(this._receiver && this._shouldReceiverDestroyWACP || !this._receiver && !this._shouldReceiverDestroyWACP)) {
            throw new IllegalStateException(RB.getStringResource("WebappContextParams.TermCalledOnSender.txt"));
        }
        WebappContextParams.cleanSessionParams(this._sessionContext, this._sessionRequestId);
    }

    public String getSessionKeyParam() throws RemoteException {
        return "saspfs_sessionid=" + this._sessionId;
    }

    public String getURL() throws RemoteException {
        if (this._url == null) {
            this.buildURL();
        }
        return this._url;
    }

    public SessionContextInterface getSessionContext() {
        return this._sessionContext;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public String getStartURL() {
        return this._startURL;
    }

    public Map getRequestParams() {
        return this._requestParams;
    }

    public String getSessionRequestId() {
        return this._sessionRequestId;
    }

    public String getPortletid() {
        return this._portletid;
    }

    public String getParamRequestType() {
        String requestType = null;
        if (this._requestParams != null) {
            requestType = (String)this._requestParams.get("saspfs_request_type");
        }
        return requestType;
    }

    public String getParamRequestSource() {
        String requestSource = null;
        if (this._requestParams != null) {
            requestSource = (String)this._requestParams.get("saspfs_request_source");
        }
        return requestSource;
    }

    public String getParamRequestAction() {
        String requestAction = null;
        if (this._requestParams != null) {
            requestAction = (String)this._requestParams.get("saspfs_request_action");
        }
        return requestAction;
    }

    public Object getParamRequestEntity() {
        Object requestEntity = null;
        if (this._requestParams != null) {
            requestEntity = this._requestParams.get("saspfs_request_entity");
        }
        return requestEntity;
    }

    public String getParamRequestEntitykey() {
        String requestEntitykey = null;
        if (this._requestParams != null) {
            requestEntitykey = (String)this._requestParams.get("saspfs_request_entitykey");
        }
        return requestEntitykey;
    }

    public String getParamRequestPathUrl() {
        String pathURL = null;
        if (this._requestParams != null) {
            pathURL = (String)this._requestParams.get("saspfs_request_path_url");
        }
        return pathURL;
    }

    public RequestActionMenuData[] getParamRequestActionmenu() {
        RequestActionMenuData[] requestActionmenu = null;
        if (this._requestParams != null) {
            requestActionmenu = (RequestActionMenuData[])this._requestParams.get("saspfs_request_actionmenu");
        }
        return requestActionmenu;
    }

    public String getParamRequestBackurl() {
        String requestBackurl = null;
        if (this._requestParams != null) {
            requestBackurl = (String)this._requestParams.get("saspfs_request_backurl");
        }
        return requestBackurl;
    }

    public String getParamRequestTimeoutBackurl() {
        String requestBackurl = null;
        if (this._requestParams != null) {
            requestBackurl = (String)this._requestParams.get("saspfs_request_timeout_backurl");
        }
        return requestBackurl;
    }

    public String getParamRequestBacklabel() {
        String requestBacklabel = null;
        if (this._requestParams != null) {
            requestBacklabel = (String)this._requestParams.get("saspfs_request_backlabel");
        }
        return requestBacklabel;
    }

    public List getParamRequestBackurlList() {
        List requestBackurlList = null;
        if (this._requestParams != null) {
            requestBackurlList = (List)this._requestParams.get("saspfs_request_backurl_list");
        }
        return requestBackurlList;
    }

    public List getParamRequestBacklabelList() {
        List requestBacklabelList = null;
        if (this._requestParams != null) {
            requestBacklabelList = (List)this._requestParams.get("saspfs_request_backlabel_list");
        }
        return requestBacklabelList;
    }

    public List getParamRequestBackdescriptionList() {
        List requestBackdescList = null;
        if (this._requestParams != null) {
            requestBackdescList = (List)this._requestParams.get("saspfs_request_backdescription_list");
        }
        return requestBackdescList;
    }

    public String getParamRequestLogoffurl() {
        String requestLogoffurl = null;
        if (this._requestParams != null) {
            requestLogoffurl = (String)this._requestParams.get("saspfs_request_logoffurl");
        }
        return requestLogoffurl;
    }

    public String getParamRequestAuthDomain() {
        String authDomain = null;
        if (this._requestParams != null) {
            authDomain = (String)this._requestParams.get("saspfs_request_auth_domain");
        }
        return authDomain;
    }

    public void setPortletid(String portletid) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("sasportal_portletid", portletid);
        this._portletid = portletid;
    }

    public void setParamRequestType(String requestType) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_type", requestType);
    }

    public void setParamRequestSource(String requestSource) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_source", requestSource);
    }

    public void setParamRequestAction(String requestAction) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_action", requestAction);
    }

    public void setParamRequestEntity(Object requestEntity) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_entity", requestEntity);
    }

    public void setParamRequestEntitykey(String requestEntitykey) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_entitykey", requestEntitykey);
    }

    public void setParamRequestPathUrl(String requestPathUrl) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_path_url", requestPathUrl);
    }

    public void setParamRequestActionmenu(RequestActionMenuData[] requestActionmenu) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_actionmenu", requestActionmenu);
    }

    public void setParamRequestBackurl(String requestBackurl) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_backurl", requestBackurl);
    }

    public void setParamRequestTimeoutBackurl(String requestBackurl) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_timeout_backurl", requestBackurl);
    }

    public void setParamRequestBacklabel(String requestBacklabel) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_backlabel", requestBacklabel);
    }

    public void setParamRequestBackurlList(List requestBackurlList) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_backurl_list", requestBackurlList);
        if (requestBackurlList != null && requestBackurlList.size() > 0) {
            this.setParamRequestBackurl((String)requestBackurlList.get(0));
        }
    }

    public void setParamRequestBacklabelList(List requestBacklabelList) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_backlabel_list", requestBacklabelList);
        if (requestBacklabelList != null && requestBacklabelList.size() > 0) {
            this.setParamRequestBacklabel((String)requestBacklabelList.get(0));
        }
    }

    public void setParamRequestBackdescriptionList(List requestBackdescList) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_backdescription_list", requestBackdescList);
    }

    public void setParamRequestLogoffurl(String requestLogoffurl) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_logoffurl", requestLogoffurl);
    }

    public void setParamRequestAuthDomain(String authDomain) throws RemoteException {
        this.makeRequestParams();
        this._requestParams.put("saspfs_request_auth_domain", authDomain);
    }

    public void setStartURL(String startURL) {
        this._startURL = startURL;
        this._url = null;
    }

    public static SessionContextInterface getSessionContext(String sessionKey) throws InitializationException, RemoteException, ServiceException {
        return WebappContextParams.getSessionContext(sessionKey, true);
    }

    public static SessionContextInterface getSessionContext(String sessionKey, boolean useRemoteServices) throws InitializationException, RemoteException, ServiceException {
        SessionServiceInterface sessionService = null;
        SessionContextInterface sessionContext = null;
        sessionService = useRemoteServices ? ServicesFacade.getRemoteSessionService() : ServicesFacade.getSessionService();
        sessionContext = sessionService.getSessionContext(sessionKey);
        return sessionContext;
    }

    public static SessionContextInterface getRemoteSessionContext(UserContextInterface privlUser, String sessionKey) throws InitializationException, RemoteException, ServiceException {
        return WebappContextParams.getSessionContext(privlUser, sessionKey, true);
    }

    public static SessionContextInterface getSessionContext(UserContextInterface user, String sessionKey, boolean useRemoteServices) throws InitializationException, RemoteException, ServiceException {
        SessionServiceInterface sessionService = null;
        SessionContextInterface sessionContext = null;
        sessionService = useRemoteServices ? ServicesFacade.getRemoteSessionService() : ServicesFacade.getSessionService();
        sessionContext = sessionService.getSessionContext(user, sessionKey);
        return sessionContext;
    }

    public static SessionContextInterface getSessionContext(UserContextInterface user, String sessionKey, SessionServiceInterface sessionService) throws InitializationException, RemoteException, ServiceException {
        SessionContextInterface retval = sessionService.getSessionContext(user, sessionKey);
        return retval;
    }

    public static void cleanSessionParams(SessionContextInterface sessionContext, String sessionRequestId) throws RemoteException {
        if (sessionContext == null) {
            return;
        }
        sessionContext.removeAttribute("saspfs_sessionrequest");
        Map requestParams = null;
        Object value = null;
        if (sessionRequestId != null && (value = sessionContext.getAttribute(sessionRequestId)) instanceof Map) {
            requestParams = (Map)value;
        }
        if (requestParams != null) {
            String key2 = null;
            value = null;
            for (String key2 : requestParams.keySet()) {
                value = requestParams.get(key2);
                if (!(value instanceof WebappContextParamsCleanupInterface)) continue;
                ((WebappContextParamsCleanupInterface)value).cleanup();
            }
        }
    }

    private void buildURL() throws RemoteException {
        this._url = this._startURL;
        if (this._sessionId != null || this._sessionRequestId != null || this._portletid != null) {
            this._url = this._startURL != null && this._startURL.indexOf(63) == -1 ? this._url + "?" : this._url + "&";
            if (this._sessionId != null) {
                this._url = this._url + "saspfs_sessionid=" + this._sessionId + "&";
            }
            if (this._sessionRequestId != null) {
                this._url = this._url + "saspfs_sessionrequest=" + this._sessionRequestId + "&";
                this._sessionContext.setAttribute(this._sessionRequestId, (Object)this._requestParams);
                if (this._portletid != null) {
                    this._url = this._url + "&";
                }
            }
            if (this._portletid != null) {
                this._url = this._url + "sasportal_portletid=" + this._portletid;
            }
        }
        if (this._url.endsWith("&")) {
            this._url = this._url.substring(0, this._url.length() - 1);
        }
    }

    private void makeRequestParams() throws RemoteException {
        if (this._requestParams == null) {
            if (this._sessionContext == null) {
                throw new IllegalStateException(RB.getStringResource("WebappContextParams.NoSessionContext.txt"));
            }
            this._requestParams = new HashMap();
            this._sessionRequestId = this._sessionContext.setAttribute((Object)this._requestParams);
        }
    }
}

