/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.components.services.impl;

import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.webapp.components.configuration.ApplicationConfiguration;
import com.sas.webapp.components.services.ServicesManager;
import com.sas.webapp.components.services.TrustedOmrUser;
import java.rmi.RemoteException;
import java.util.Map;

public class TrustedOmrUserImpl
implements TrustedOmrUser {
    private UserContextInterface _userContext;

    public TrustedOmrUserImpl(ApplicationConfiguration config, ServicesManager servicesManager) {
        try {
            this._userContext = this.createUserContext(config, servicesManager);
        }
        catch (Exception e) {
            Map connMap;
            if (config != null && (connMap = config.getMap("omr-connection")) != null) {
                String userId = (String)connMap.get("omr-user");
                String domain = (String)connMap.get("omr-domain");
                System.out.println("Could not create userContext for user [" + userId + "] authDomain [" + domain + "].\nCheck this against the InformationService Foundation Service entry in OMR");
            }
            e.printStackTrace();
        }
    }

    @Override
    public UserContextInterface getUserContext() {
        return this._userContext;
    }

    public void dispose() {
        if (this._userContext != null) {
            try {
                this._userContext.destroy();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this._userContext = null;
        }
    }

    private UserContextInterface createUserContext(ApplicationConfiguration config, ServicesManager servicesManager) throws Exception {
        UserContextInterface retval = null;
        String domain = config.getValueFromMap("omr-connection", "omr-domain");
        String userId = config.getValueFromMap("omr-connection", "omr-user");
        String password = config.getValueFromMap("omr-connection", "omr-password");
        UserServiceInterface userService = servicesManager.getUserService();
        retval = userService.newUser(userId, password, domain);
        return retval;
    }
}

