/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.components.services.impl;

import com.sas.services.InitializationException;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.OMRMetadataSource;
import com.sas.services.deployment.ServiceLoader;
import com.sas.services.deployment.ServiceLookupFailedException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.MetadataAttribute;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryDef;
import com.sas.services.webapp.InitParamBean;
import com.sas.services.webapp.res.RB;
import com.sas.webapp.components.configuration.ApplicationConfiguration;
import com.sas.webapp.components.services.ServicesInitializer;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import org.picocontainer.Disposable;

public class ServicesInitializerImpl
implements Disposable,
ServicesInitializer {
    private static final String RB_REMOTE_DEPLOY = "remote_deploy.txt";
    private static final String RB_REMOTE_NOT_AVAILABLE = "remote_not_available.txt";
    private static final String RB_REMOTE_BIND = "remote_bind.txt";
    private static final String RB_REMOTE_BOUND = "remote_bound.txt";
    private static final String RB_REMOTE_METADATASOURCE_NOT_LOADED = "remote_metadatasource_not_loaded.txt";
    private static final String RB_MISSING_REPOS_PROP = "missing_repos_prop.txt";
    private static final String RB_ENABLED_COMMON_SYSTEM_PROPS = "enabled_common_system_props.txt";
    static final String SYSTEM_PROP_CONFIG = System.getProperty("sas.web.config");
    private DiscoveryServiceInterface _discoveryService = DiscoveryService.defaultInstance();
    private MetadataSourceInterface _localMS;
    private boolean _isRemoteBound;
    private ServiceAttributeInterface[] _remoteServiceAttributes;
    private ServiceAttributeInterface[] _localServiceAttributes;
    private StringBuffer _sbStats = new StringBuffer();
    private static final String INIT_SYSTEM_PROPS = "SystemPropsFile";
    private InitParamBean _localParams;
    private InitParamBean _remoteParams;

    public ServicesInitializerImpl(ApplicationConfiguration config) throws ServiceException, InitializationException {
        this(config, false);
    }

    public ServicesInitializerImpl(ApplicationConfiguration config, boolean isRemoteBound) throws ServiceException, InitializationException {
        this._isRemoteBound = isRemoteBound;
        this._localParams = this.populateInitParamBean(config, false);
        String remoteAvail = this.loadFromInitialConfig(config, "services-bootstrap", "remote-software-component", false);
        if (remoteAvail != null) {
            this._remoteParams = this.populateInitParamBean(config, true);
        }
        this.printParams();
        this.init();
    }

    @Override
    public ServiceAttributeInterface[] getRemoteServiceAttributes() throws InitializationException, ServiceException {
        if (this._remoteServiceAttributes == null) {
            throw new InitializationException(RB.getStringResource((String)RB_REMOTE_METADATASOURCE_NOT_LOADED));
        }
        if (!this._isRemoteBound) {
            this.bindRemote();
        }
        return this._remoteServiceAttributes;
    }

    @Override
    public ServiceAttributeInterface[] getLocalServiceAttributes() {
        return this._localServiceAttributes;
    }

    private void setRemoteServiceAttributes() {
        String remoteSoftwareComponent = this._remoteParams.getSoftwareComponent();
        this._remoteServiceAttributes = new ServiceAttributeInterface[]{new MetadataAttribute(null, remoteSoftwareComponent, "SoftwareComponent", null)};
    }

    private void init() throws ServiceException, InitializationException {
        this.deployLocalServices();
        this.setLocalServiceAttributes();
        if (this._remoteParams != null) {
            this.setRemoteServiceAttributes();
        }
        try {
            this.printLocalInfo();
            this._localMS.destroy();
            this._localMS = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private MetadataSourceInterface loadRemoteMetadataSource() throws ServiceException, InitializationException {
        OMRMetadataSource retval = null;
        if (this._remoteParams.getDeploymentGroup2() == null) {
            retval = new OMRMetadataSource(this._remoteParams.getOmrHost(), this._remoteParams.getOmrPort(), this._remoteParams.getOmrUser(), this._remoteParams.getOmrPassword(), this._remoteParams.getOmrRepository(), this._remoteParams.getSoftwareComponent(), this._remoteParams.getDeploymentGroup1());
        } else {
            HashSet<String> x = new HashSet<String>();
            x.add(this._remoteParams.getDeploymentGroup1());
            x.add(this._remoteParams.getDeploymentGroup2());
            retval = new OMRMetadataSource(this._remoteParams.getOmrHost(), this._remoteParams.getOmrPort(), this._remoteParams.getOmrUser(), this._remoteParams.getOmrPassword(), this._remoteParams.getOmrRepository(), this._remoteParams.getSoftwareComponent(), x);
        }
        try {
            System.out.println(RB.getStringResource((String)RB_REMOTE_DEPLOY));
        }
        catch (MissingResourceException mre) {
            System.out.println(mre.getMessage());
        }
        return retval;
    }

    private void deployLocalServices() throws ServiceException, InitializationException {
        if (this._localParams.getDeploymentGroup2() == null) {
            this._localMS = new OMRMetadataSource(this._localParams.getOmrHost(), this._localParams.getOmrPort(), this._localParams.getOmrUser(), this._localParams.getOmrPassword(), this._localParams.getOmrRepository(), this._localParams.getSoftwareComponent(), this._localParams.getDeploymentGroup1());
        } else {
            HashSet<String> x = new HashSet<String>();
            x.add(this._localParams.getDeploymentGroup1());
            x.add(this._localParams.getDeploymentGroup2());
            this._localMS = new OMRMetadataSource(this._localParams.getOmrHost(), this._localParams.getOmrPort(), this._localParams.getOmrUser(), this._localParams.getOmrPassword(), this._localParams.getOmrRepository(), this._localParams.getSoftwareComponent(), x);
        }
        System.setProperty("com.sas.services.logging.disableRemoteLogging", "true");
        System.setProperty("com.sas.services.logging.disableRemoteList", "true");
        ServiceLoader.deployServices((MetadataSourceInterface)this._localMS, (DiscoveryServiceInterface)this._discoveryService);
    }

    private void bindRemote() throws InitializationException, ServiceException {
        if (!this._isRemoteBound) {
            try {
                MetadataSourceInterface remoteMetadataSource = this.loadRemoteMetadataSource();
                ServiceLoader.lookupRemoteDiscoveryServices((MetadataSourceInterface)remoteMetadataSource, (DiscoveryServiceInterface)this._discoveryService);
                System.out.println(RB.getStringResource((String)RB_REMOTE_BIND) + "\n\t to " + remoteMetadataSource.toString());
                remoteMetadataSource.destroy();
                System.out.println(RB.getStringResource((String)RB_REMOTE_BOUND));
                this._isRemoteBound = true;
            }
            catch (ServiceLookupFailedException sfe) {
                this._isRemoteBound = false;
                System.out.println(RB.getStringResource((String)RB_REMOTE_NOT_AVAILABLE));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
        }
    }

    private void setLocalServiceAttributes() throws InitializationException, ServiceException {
        if (this._localServiceAttributes == null) {
            String softwareComponent = this._localParams.getSoftwareComponent();
            this._localServiceAttributes = new ServiceAttributeInterface[]{new MetadataAttribute(null, softwareComponent, "SoftwareComponent", null)};
        }
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(this._sbStats.toString()).append("\n").append("LocalParams\n").append(this._localParams).append("\n").append("RemoteParams\n").append(this._remoteParams).append("\n").append("RemoteBound: ").append(this._isRemoteBound);
        return retval.toString();
    }

    @Override
    public DiscoveryServiceInterface getDefaultDiscoveryService() {
        return this._discoveryService;
    }

    public void dispose() {
        try {
            this._discoveryService.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this._localMS != null) {
                this._localMS.destroy();
                this._localMS = null;
            }
            this._discoveryService = null;
            this._isRemoteBound = false;
            this._remoteServiceAttributes = null;
            this._localServiceAttributes = null;
            this._remoteServiceAttributes = null;
        }
    }

    public void printLocalInfo() {
        System.out.println();
        System.out.println("--- Foundation Services information ---");
        try {
            Iterator it = this._discoveryService.getLocalServices();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof InformationServiceInterface)) continue;
                this.printInformationServiceDetails((InformationServiceInterface)o);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void printInformationServiceDetails(InformationServiceInterface o) throws RemoteException {
        System.out.println(InformationServiceInterface.class.getName() + "[ ");
        InformationServiceInterface info = o;
        List l = info.getReposDefs();
        for (RepositoryDef def : l) {
            System.out.println("\tRepositoryDef: [");
            System.out.println("\t  name=" + def.getName());
            System.out.println("\t  base=" + def.getBase());
            System.out.println("\t  host=" + def.getHost());
            System.out.println("\t  port=" + def.getPort());
            System.out.println("\t  type=" + def.getProtocol());
            System.out.println("\t  auto=" + def.getAuto());
            System.out.println("\t]");
        }
        System.out.println("]");
    }

    private void printParams() {
        System.out.println();
        System.out.println("Local Services properties: [");
        this.printProperties(this._localParams);
        if (this._remoteParams != null) {
            System.out.println("Remote Services properties: [");
            this.printProperties(this._remoteParams);
        }
    }

    private void printProperties(InitParamBean parms) {
        System.out.println("\tdeployment_group_1=" + parms.getDeploymentGroup1());
        if (parms.getDeploymentGroup2() != null) {
            System.out.println("\tdeployment_group_2=" + parms.getDeploymentGroup2());
        }
        System.out.println("\tomr_host=" + parms.getOmrHost());
        System.out.println("\tomr_password=******");
        System.out.println("\tomr_port=" + parms.getOmrPort());
        System.out.println("\tomr_repository=" + parms.getOmrRepository());
        System.out.println("\tomr_user=" + parms.getOmrUser());
        System.out.println("\tsoftware_component=" + parms.getSoftwareComponent());
        System.out.println("]");
    }

    private InitParamBean populateInitParamBean(ApplicationConfiguration config, boolean isRemote) {
        String deploymentGroup2Str;
        String deploymentGroup1Str;
        String softwareComponentStr;
        InitParamBean retval = new InitParamBean();
        if (isRemote) {
            softwareComponentStr = this.loadFromInitialConfig(config, "services-bootstrap", "remote-software-component");
            deploymentGroup1Str = this.loadFromInitialConfig(config, "services-bootstrap", "remote-deployment-group-1");
            deploymentGroup2Str = this.loadFromInitialConfig(config, "services-bootstrap", "remote-deployment-group-2", false);
        } else {
            softwareComponentStr = this.loadFromInitialConfig(config, "services-bootstrap", "local-software-component");
            deploymentGroup1Str = this.loadFromInitialConfig(config, "services-bootstrap", "local-deployment-group-1");
            deploymentGroup2Str = this.loadFromInitialConfig(config, "services-bootstrap", "local-deployment-group-2", false);
        }
        String omrHostStr = this.loadFromInitialConfig(config, "omr-connection", "omr-host");
        String omrPortStr = this.loadFromInitialConfig(config, "omr-connection", "omr-port");
        String omrUserStr = this.loadFromInitialConfig(config, "omr-connection", "omr-user");
        String omrPasswordStr = this.loadFromInitialConfig(config, "omr-connection", "omr-password");
        String omrReposStr = this.loadFromInitialConfig(config, "omr-connection", "omr-repository");
        retval.setSoftwareComponent(softwareComponentStr);
        retval.setDeploymentGroup1(deploymentGroup1Str);
        retval.setDeploymentGroup2(deploymentGroup2Str);
        retval.setOmrHost(omrHostStr);
        retval.setOmrPort(omrPortStr);
        retval.setOmrUser(omrUserStr);
        retval.setOmrPassword(omrPasswordStr);
        retval.setOmrRepository(omrReposStr);
        return retval;
    }

    private String loadFromInitialConfig(ApplicationConfiguration config, String mapName, String valueToRead) {
        return this.loadFromInitialConfig(config, mapName, valueToRead, true);
    }

    private String loadFromInitialConfig(ApplicationConfiguration config, String mapName, String valueToRead, boolean flagMissing) {
        String retval = config.getValueFromMap(mapName, valueToRead);
        if (flagMissing && retval == null) {
            System.out.println("\t\tMissing value for \"" + valueToRead + "\" from application_config.xml");
        }
        return retval;
    }
}

