/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.components.content.adapters.impl;

import com.sas.webapp.components.configuration.ApplicationConfiguration;
import com.sas.webapp.components.content.adapters.AdapterRequest;
import com.sas.webapp.components.content.adapters.AdapterRequestDispatcher;
import com.sas.webapp.components.content.adapters.AdapterResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdapterRequestDispatcherImpl
implements AdapterRequestDispatcher {
    private Logger _logger = LogManager.getLogger(this.getClass());
    private String _baseUrl;

    public AdapterRequestDispatcherImpl(ApplicationConfiguration config, Logger logger) {
        this._logger = logger;
        this._baseUrl = config.getValueFromMap("adapter", "baseUrl");
    }

    @Override
    public AdapterResponse dispatch(AdapterRequest adapterRequest) {
        AdapterResponse retval = null;
        try {
            AdapterResponse adapterResponse = this.ensureRemoteLogon(adapterRequest);
            if (this._logger.isDebugEnabled()) {
                this.logResponse(adapterResponse);
            }
            if (adapterResponse.statusOK()) {
                adapterResponse.destroy();
                retval = this.executeRequest(adapterRequest);
                if (this._logger.isDebugEnabled()) {
                    this.logResponse(retval);
                }
            } else {
                retval = adapterResponse;
            }
        }
        catch (Exception e) {
            this._logger.error(adapterRequest.getRequestURL().toString());
            this._logger.error(e.getMessage());
        }
        return retval;
    }

    private AdapterResponse ensureRemoteLogon(AdapterRequest adapterRequest) throws Exception {
        AdapterResponse retval = null;
        AdapterRequest logonRequest = new AdapterRequest();
        logonRequest.init(adapterRequest);
        logonRequest.isGetMethod(true);
        String logonAction = null;
        String remoteSessionParam = adapterRequest.getRemoteSessionParam();
        logonAction = remoteSessionParam != null ? "adapter/logon.do?" + remoteSessionParam : "adapter/logon.do";
        String adapterUrl = this.getLogonAdapterUrl(this._baseUrl, logonAction, null);
        logonRequest.setRequestUrl(adapterUrl);
        retval = this.executeRequest(logonRequest);
        return retval;
    }

    private String getLogonAdapterUrl(String url, String logonAction, String requestParams) {
        StringBuffer retval = new StringBuffer();
        retval.append(url);
        retval.append(logonAction);
        if (requestParams != null) {
            retval.append("?").append(requestParams);
        }
        return retval.toString();
    }

    private void logResponse(AdapterResponse adapterResponse) {
        System.out.print(adapterResponse);
        this._logger.info(adapterResponse.toString());
    }

    private AdapterResponse executeRequest(AdapterRequest adapterRequest) throws Exception {
        AdapterResponse retval = new AdapterResponse(this._logger);
        retval.init(adapterRequest);
        retval.execute();
        if (!retval.statusOK() && !retval.statusNeedsLogon()) {
            this._logger.warn(retval.toString());
            System.out.println(retval);
        }
        return retval;
    }
}

