/*
 * Decompiled with CFR 0.152.
 */
package com.sas.webapp.components.content.adapters;

import com.sas.webapp.components.content.adapters.AdapterRequest;
import com.sas.webapp.components.content.adapters.SSLHandshakeCompletedListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.Logger;

public class AdapterResponse {
    private String LOGGING_CONTEXT = this.getClass().getName();
    private int _httpStatus;
    private String _responseAsString;
    private HttpClient _httpClient;
    private Logger _logger;
    private Socket _socket;
    private String _hostHeader;
    private boolean _isGetMethod;
    private HttpGet _getMethod;
    private HttpPost _postMethod;
    private URL _requestURL;
    private InputStream _inputStream;
    private boolean _initialized;

    public AdapterResponse(Logger logger) {
        this._logger = logger;
    }

    public void init(AdapterRequest adapterRequest) throws Exception {
        this._httpClient = HttpClientBuilder.create().build();
        this._requestURL = adapterRequest.getRequestURL();
        this._socket = this.openSocket();
        StringBuffer hostHeader = new StringBuffer();
        hostHeader.append(this._requestURL.getHost()).append(":").append(this._requestURL.getPort());
        this._hostHeader = hostHeader.toString();
        this._isGetMethod = adapterRequest.isGetMethod();
        this._initialized = true;
    }

    public void execute() throws IllegalStateException {
        if (!this._initialized) {
            throw new IllegalStateException();
        }
        HttpResponse httpResponse = null;
        try {
            if (this._isGetMethod) {
                this._getMethod = this.createGetMethod();
                httpResponse = this._httpClient.execute((HttpUriRequest)this._getMethod);
                this._httpStatus = httpResponse.getStatusLine().getStatusCode();
            } else {
                this._postMethod = this.createPostMethod();
                httpResponse = this._httpClient.execute((HttpUriRequest)this._postMethod);
                this._httpStatus = httpResponse.getStatusLine().getStatusCode();
            }
        }
        catch (Exception e) {
            String errorMessage = "\nAdapter Error: " + this._requestURL.toString() + "\n" + e.getMessage();
            if (httpResponse != null) {
                this._httpStatus = httpResponse.getStatusLine().getStatusCode();
                this._responseAsString = e.getMessage();
            }
            if (!this.statusNeedsLogon()) {
                this._logger.error(errorMessage);
            }
            this.destroy();
        }
    }

    public void destroy() {
        try {
            if (this._inputStream != null) {
                this._inputStream.close();
                this._inputStream = null;
            }
            this._getMethod = null;
            this._postMethod = null;
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._initialized = false;
    }

    public int getHttpStatus() {
        return this._httpStatus;
    }

    public String getResponseAsString() {
        return this._responseAsString;
    }

    public InputStream getInputStream() {
        return this._inputStream;
    }

    public String toString() {
        return "\nhttpStatus: " + this._httpStatus + "\nresponse\n" + this._responseAsString;
    }

    public boolean statusOK() {
        return this._httpStatus == 200;
    }

    public boolean statusNeedsLogon() {
        return this._httpStatus == 407;
    }

    public void setResponseAsString(String transformedHtml) {
        this._responseAsString = transformedHtml;
    }

    private HttpGet createGetMethod() {
        HttpGet retval = new HttpGet(this._requestURL.getPath());
        return retval;
    }

    private HttpPost createPostMethod() {
        HttpPost retval = new HttpPost(this._requestURL.getPath());
        return retval;
    }

    private Socket openSocket() throws IOException {
        String hostName = this._requestURL.getHost();
        int port = this._requestURL.getPort();
        InetAddress addr = InetAddress.getByName(hostName);
        Socket retval = null;
        String protocol = this._requestURL.getProtocol().toLowerCase();
        retval = protocol.equals("https") ? this.openSSLSocket(addr, port) : this.openStandardSocket(addr, port);
        retval.setSoTimeout(30000);
        retval.setTcpNoDelay(true);
        retval.setSoLinger(false, -1);
        return retval;
    }

    private Socket openStandardSocket(InetAddress addr, int port) throws IOException {
        Socket retval = new Socket(addr, port);
        return retval;
    }

    private Socket openSSLSocket(InetAddress addr, int port) throws IOException {
        SocketFactory socketFactory = SSLSocketFactory.getDefault();
        SSLSocket socket = (SSLSocket)socketFactory.createSocket(addr, port);
        SSLHandshakeCompletedListener listener = new SSLHandshakeCompletedListener();
        socket.addHandshakeCompletedListener(listener);
        socket.startHandshake();
        while (!listener.isComplete()) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return socket;
    }
}

