/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.vendor;

import com.sas.svcs.data.vendor.DatabaseVendor;
import com.sas.svcs.data.vendor.DatabaseVendorUtils;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class DatabaseVendorFactoryBean
implements FactoryBean<DatabaseVendor>,
InitializingBean {
    private DataSource _dataSource;
    private DatabaseVendor _databaseVendor;

    public DatabaseVendor getObject() {
        if (null != this._dataSource) {
            try {
                this._databaseVendor = DatabaseVendorUtils.getVendor(this._dataSource);
                this._dataSource = null;
            }
            catch (SQLException e) {
                LogManager.getLogger(DatabaseVendorFactoryBean.class).error("Unable to determine the database's vendor using a JDBC data source.", (Throwable)e);
            }
        }
        return this._databaseVendor;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public Class<DatabaseVendor> getObjectType() {
        return DatabaseVendor.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this._dataSource) {
            throw new IllegalStateException("Property 'dataSource' must be specified.");
        }
    }
}

