/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.dao.mybatis;

import com.sas.svcs.data.vendor.DatabaseVendor;
import com.sas.svcs.data.vendor.DatabaseVendorUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.SqlSessionUtils;
import org.mybatis.spring.support.SqlSessionDaoSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class SQLSessionDAOSupport
extends SqlSessionDaoSupport {
    private static final Logger LOGGER = LogManager.getLogger(SQLSessionDAOSupport.class);
    private DatabaseVendor _databaseVendor;

    public synchronized DatabaseVendor getDatabaseVendor() {
        Connection connection;
        SqlSession sqlSession;
        if (null == this._databaseVendor && null != (sqlSession = this.getSqlSession()) && null != (connection = sqlSession.getConnection())) {
            try {
                if (connection.isClosed()) {
                    SqlSessionTemplate st = (SqlSessionTemplate)sqlSession;
                    connection = SqlSessionUtils.getSqlSession((SqlSessionFactory)st.getSqlSessionFactory(), (ExecutorType)st.getExecutorType(), (PersistenceExceptionTranslator)st.getPersistenceExceptionTranslator()).getConnection();
                }
                this._databaseVendor = DatabaseVendorUtils.getVendor(connection);
            }
            catch (SQLException e) {
                LOGGER.error("Unable to determine database vendor.", (Throwable)e);
            }
        }
        return this._databaseVendor;
    }

    public void setDatabaseVendor(DatabaseVendor vendor) {
        this._databaseVendor = vendor;
    }

    @Autowired(required=false)
    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        super.setSqlSessionFactory(sqlSessionFactory);
    }

    @Autowired(required=false)
    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        super.setSqlSessionTemplate(sqlSessionTemplate);
    }
}

