/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.dao.mybatis;

import com.sas.svcs.data.vendor.DatabaseVendor;
import com.sas.svcs.data.vendor.DatabaseVendorUtils;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class ClobTypeHandler
implements TypeHandler<String> {
    private DatabaseVendor vendor;

    private synchronized DatabaseVendor getVendor(Connection connection) throws SQLException {
        if (null == this.vendor) {
            this.vendor = DatabaseVendorUtils.getVendor(connection);
        }
        return this.vendor;
    }

    public void setParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, parameter);
    }

    public String getResult(ResultSet rs, String columnName) throws SQLException {
        if (DatabaseVendor.POSTGRES == this.getVendor(rs.getStatement().getConnection())) {
            return rs.getString(columnName);
        }
        Clob clob = rs.getClob(columnName);
        return clob == null ? "" : clob.getSubString(1L, (int)clob.length());
    }

    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        if (DatabaseVendor.POSTGRES == this.getVendor(rs.getStatement().getConnection())) {
            return rs.getString(columnIndex);
        }
        Clob clob = rs.getClob(columnIndex);
        return clob == null ? "" : clob.getSubString(1L, (int)clob.length());
    }

    public String getResult(CallableStatement cs, int columnIndex) throws SQLException {
        if (DatabaseVendor.POSTGRES == this.getVendor(cs.getConnection())) {
            return cs.getString(columnIndex);
        }
        Clob clob = cs.getClob(columnIndex);
        return clob == null ? "" : clob.getSubString(1L, (int)clob.length());
    }
}

