/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.dao.mybatis;

import com.sas.svcs.data.dao.mybatis.SQLSessionDAOSupport;
import com.sas.svcs.data.vendor.DatabaseVendor;
import java.util.List;

public class BulkSQLSessionDAOSupport
extends SQLSessionDAOSupport {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private int _batchSize = 100;

    public void setBatchSize(int batchSize) {
        if (0 >= batchSize) {
            throw new IllegalArgumentException("Batch size must be greater than zero.");
        }
        this._batchSize = batchSize;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public int bulkUpdate(String sqlMapName, List<?> entries) {
        int numInserts = 0;
        int size = entries.size();
        int batchSize = this.getBatchSizeForRequest(size);
        if (0 < batchSize) {
            int idx;
            int numBatches = size / batchSize * batchSize;
            for (idx = 0; idx < numBatches; idx += batchSize) {
                numInserts += this.getSqlSession().insert(sqlMapName, entries.subList(idx, idx + batchSize));
            }
            int rest = size - numBatches;
            if (0 < rest) {
                numInserts += this.getSqlSession().insert(sqlMapName, entries.subList(idx, idx + rest));
            }
        }
        return numInserts;
    }

    private int getBatchSizeForRequest(int size) {
        DatabaseVendor databaseVendor = this.getDatabaseVendor();
        return null == databaseVendor ? 1 : (databaseVendor.hasBulkInsert() ? Math.min(size, this._batchSize) : 1);
    }
}

