/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.dao.jdbc;

import com.sas.svcs.data.vendor.DatabaseVendor;
import com.sas.svcs.data.vendor.DatabaseVendorUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import javax.sql.DataSource;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.jdbc.object.SqlUpdate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class SqlInsert {
    private SqlUpdate sqlUpdate;
    private String keyColumnName;
    private Integer[] booleanToSmallintIndexes = new Integer[0];

    public SqlInsert(DataSource ds, String sql, int[] types, String keyColumnName) {
        this(ds, sql, keyColumnName, false, types);
    }

    public SqlInsert(DataSource ds, String sql, String keyColumnName, boolean transformBools, int ... types) {
        if (transformBools) {
            try {
                DatabaseVendor vendor = DatabaseVendorUtils.getVendor(ds);
                if (DatabaseVendor.ORACLE.equals((Object)vendor) || DatabaseVendor.DB2.equals((Object)vendor)) {
                    ArrayList<Integer> indices = new ArrayList<Integer>();
                    for (int index = 0; index < types.length; ++index) {
                        if (16 != types[index]) continue;
                        types[index] = 5;
                        indices.add(index);
                    }
                    if (indices.size() > 0) {
                        this.booleanToSmallintIndexes = indices.toArray(new Integer[indices.size()]);
                    }
                }
            }
            catch (SQLException e) {
                throw new RecoverableDataAccessException("Error determining database vendor", (Throwable)e);
            }
        }
        this.sqlUpdate = new SqlUpdate(ds, sql, types);
        this.keyColumnName = keyColumnName;
    }

    public String insert(Object[] params) {
        for (int index = 0; index < this.booleanToSmallintIndexes.length; ++index) {
            int paramIndex = this.booleanToSmallintIndexes[index];
            if (paramIndex >= params.length) {
                throw new IllegalArgumentException("Params array length does not match types array length");
            }
            Object param = params[paramIndex];
            if (!(param instanceof Boolean)) continue;
            params[paramIndex] = (Boolean)param != false ? 1 : 0;
        }
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.sqlUpdate.setReturnGeneratedKeys(true);
        this.sqlUpdate.setGeneratedKeysColumnNames(new String[]{this.keyColumnName.toLowerCase(Locale.ENGLISH)});
        this.sqlUpdate.update(params, (KeyHolder)holder);
        Object keyObj = holder.getKeys().get(this.keyColumnName);
        Number keyNum = null;
        keyNum = keyObj instanceof Number ? (Number)((Number)keyObj) : (Number)holder.getKey();
        return Long.toString(keyNum.longValue());
    }
}

