/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.dao;

import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectNotFoundException;
import com.sas.svcs.data.dao.GenericDAO;
import com.sas.svcs.data.dao.GenericDAOListener;
import com.sas.svcs.data.dao.IdGenerator;
import java.util.Collection;

public abstract class GenericDAOBase<T extends Identifiable>
implements GenericDAO<T> {
    private GenericDAOListener<T> listener;
    private IdGenerator idGenerator;

    public void setListener(GenericDAOListener<T> listener) {
        this.listener = listener;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    protected IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    protected void firePreCreate(T obj) {
        if (this.listener != null) {
            this.listener.onPreCreate(obj);
        }
    }

    protected void firePostCreate(T obj) {
        if (this.listener != null) {
            this.listener.onPostCreate(obj);
        }
    }

    protected void firePreUpdate(T obj) {
        if (this.listener != null) {
            this.listener.onPreUpdate(obj);
        }
    }

    protected void firePostUpdate(T obj) {
        if (this.listener != null) {
            this.listener.onPostUpdate(obj);
        }
    }

    protected void firePreDelete(T obj) {
        if (this.listener != null) {
            this.listener.onPreDelete(obj);
        }
    }

    protected void firePostDelete(T obj) {
        if (this.listener != null) {
            this.listener.onPostDelete(obj);
        }
    }

    protected void firePostFind(T obj) {
        if (this.listener != null && obj != null) {
            this.listener.onPostFind(obj);
        }
    }

    protected void firePostFind(Collection<T> objs) {
        if (this.listener != null) {
            for (Identifiable obj : objs) {
                this.listener.onPostFind(obj);
            }
        }
    }

    protected void firePreDelete(Collection<T> objs) {
        if (this.listener != null) {
            for (Identifiable obj : objs) {
                this.listener.onPreDelete(obj);
            }
        }
    }

    protected void firePostDelete(Collection<T> objs) {
        if (this.listener != null) {
            for (Identifiable obj : objs) {
                this.listener.onPostDelete(obj);
            }
        }
    }

    protected GenericDAOListener<T> getListener() {
        return this.listener;
    }

    @Override
    public void deleteById(String id) throws ObjectNotFoundException {
        Object obj = this.find(id);
        if (obj == null) {
            throw new ObjectNotFoundException("Object with id: " + id + " not found.");
        }
        this.delete(obj);
    }

    @Override
    public void delete(Collection<T> objects) throws ObjectNotFoundException {
        for (Identifiable obj : objects) {
            this.delete(obj);
        }
    }

    @Override
    public void deleteByIds(Collection<String> ids) throws ObjectNotFoundException {
        for (String id : ids) {
            this.deleteById(id);
        }
    }
}

