/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire.springframework;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class GemfireDiskStoreBean
implements FactoryBean<DiskStore>,
InitializingBean,
BeanNameAware {
    private DiskStore diskStore;
    private Cache cache;
    private String name;
    private int queueSize;
    private boolean autoCompact;
    private int maxOplogSize;
    private int timeInterval;
    private String diskLoc;
    private int diskMaxSize;
    private static final Logger LOGGER = LogManager.getLogger(GemfireDiskStoreBean.class);

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public boolean isAutoCompact() {
        return this.autoCompact;
    }

    public void setAutoCompact(boolean autoCompact) {
        this.autoCompact = autoCompact;
    }

    public int getMaxOplogSize() {
        return this.maxOplogSize;
    }

    public void setMaxOplogSize(int maxOplogSize) {
        this.maxOplogSize = maxOplogSize;
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(int timeInterval) {
        this.timeInterval = timeInterval;
    }

    public String getDiskLoc() {
        return this.diskLoc;
    }

    public void setDiskLoc(String diskLoc) {
        this.diskLoc = diskLoc;
    }

    public int getDiskMaxSize() {
        return this.diskMaxSize;
    }

    public void setDiskMaxSize(int diskMaxSize) {
        this.diskMaxSize = diskMaxSize;
    }

    public DiskStore getObject() throws Exception {
        return this.diskStore;
    }

    public Class<?> getObjectType() {
        return DiskStore.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String arg0) {
        this.name = arg0;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.info("Creating Geode disk store " + this.name + ".");
        DiskStoreFactory factory = this.cache.createDiskStoreFactory();
        factory.setQueueSize(this.queueSize);
        factory.setAutoCompact(this.autoCompact);
        factory.setTimeInterval((long)this.timeInterval);
        factory.setMaxOplogSize((long)this.maxOplogSize);
        if (!StringUtils.isEmpty((CharSequence)this.diskLoc) && this.diskMaxSize > 0) {
            factory.setDiskDirsAndSizes(new File[]{new File(this.diskLoc)}, new int[]{this.diskMaxSize});
        }
        this.diskStore = factory.create(this.name == null ? "DEFAULT" : this.name);
    }
}

