/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire.springframework;

import com.sas.svcs.data.caches.gemfire.springframework.GemfireCache;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;
import org.springframework.util.Assert;

public class GemfireCacheManager
extends AbstractCacheManager {
    private org.apache.geode.cache.Cache gemfireCache;
    private Set<Region<?, ?>> regions;

    public GemfireCacheManager(org.apache.geode.cache.Cache cache) {
        this.gemfireCache = cache;
    }

    protected Collection<Cache> loadCaches() {
        if (this.regions == null) {
            Assert.notNull((Object)this.gemfireCache, (String)"a backing GemFire cache is required");
            Assert.isTrue((!this.gemfireCache.isClosed() ? 1 : 0) != 0, (String)"the GemFire cache is closed; an open instance is required");
            this.regions = this.gemfireCache.rootRegions();
        }
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>(this.regions.size());
        for (Region<?, ?> region : this.regions) {
            caches.add(new GemfireCache(region));
        }
        return caches;
    }

    public Cache getCache(String name) {
        Region reg;
        Cache cache = super.getCache(name);
        if (cache == null && (reg = this.gemfireCache.getRegion(name)) != null) {
            cache = new GemfireCache(reg);
            this.addCache(cache);
        }
        return cache;
    }
}

