/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire.springframework;

import com.sas.svcs.data.caches.gemfire.springframework.DistributedEvictionCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class DistributedEvictionCacheManager
implements CacheManager,
DisposableBean {
    private static final Logger LOGGER = LogManager.getLogger(DistributedEvictionCacheManager.class);
    private CacheManager delegateCacheManager;
    private Map<String, DistributedEvictionCache> caches = new HashMap<String, DistributedEvictionCache>();

    @Required
    public void setDelegateCacheManager(CacheManager cacheManager) {
        this.delegateCacheManager = cacheManager;
    }

    public void setCaches(Map<String, DistributedEvictionCache> caches) {
        this.caches = caches;
    }

    public synchronized Cache getCache(String name) {
        boolean debug = LOGGER.isDebugEnabled();
        DistributedEvictionCache ret = this.caches.get(name);
        if (null == ret) {
            Cache cache;
            if (debug) {
                LOGGER.debug("Cache doesn't exist yet: " + name + " - attempting to create.");
            }
            if ((cache = this.delegateCacheManager.getCache(name)) != null) {
                if (debug) {
                    LOGGER.debug("Gemfire cache found: " + name);
                }
                ret = new DistributedEvictionCache(cache.getName(), cache);
                this.caches.put(name, ret);
            }
        }
        return ret;
    }

    public Collection<String> getCacheNames() {
        return this.caches.keySet();
    }

    public synchronized void destroy() throws Exception {
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            LOGGER.debug("Destroying cache manager");
        }
        for (DistributedEvictionCache cache : this.caches.values()) {
            if (debug) {
                LOGGER.debug("Destroying cache: " + cache.getName());
            }
            cache.destroy();
        }
    }
}

