/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire.springframework;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.lang.Nullable;

public class DistributedEvictionCache
implements Cache {
    private static final Logger LOGGER = LogManager.getLogger(DistributedEvictionCache.class);
    protected static final Object NULL_OBJECT = new Object();
    protected static final Object unique = UUID.randomUUID();
    private static final String CACHED_OBJECT_VALUE = "com.sas.svcs.CachedObject";
    private final Cache delegateCache;
    private Map<Object, Object> localMap = new HashMap<Object, Object>();
    private final String cacheName;

    public DistributedEvictionCache(String cacheName, Cache cache) {
        this.cacheName = cacheName;
        this.delegateCache = cache;
    }

    public void setLocalMap(Map<Object, Object> localMap) {
        this.localMap = localMap;
    }

    public synchronized void clear() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Clearing cache: " + this.cacheName);
        }
        this.delegateCache.clear();
        this.localMap.clear();
    }

    public synchronized void evict(Object key) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Evicting key: " + key + " from cache: " + this.cacheName);
        }
        this.clear();
    }

    public Cache.ValueWrapper get(Object key) {
        Object ret;
        KeyWrapper keyWrapper = new KeyWrapper(unique, key);
        Cache.ValueWrapper wrapper = this.delegateCache.get((Object)keyWrapper);
        if (wrapper != null && (ret = this.localMap.get(key)) != null) {
            return new SimpleValueWrapper(ret == NULL_OBJECT ? null : ret);
        }
        return null;
    }

    public <T> T get(Object key, @Nullable Class<T> type) {
        Object o = this.localMap.get(key);
        Object t = null;
        try {
            t = o;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return (T)t;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        Object o = this.localMap.get(key);
        Object t = null;
        try {
            t = o;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return (T)t;
    }

    public String getName() {
        return this.cacheName;
    }

    public Object getNativeCache() {
        return this.delegateCache.getNativeCache();
    }

    public synchronized void put(Object key, Object value) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Putting key: " + key + " in cache: " + this.cacheName + " with value: " + value);
        }
        this.delegateCache.put((Object)new KeyWrapper(unique, key), (Object)CACHED_OBJECT_VALUE);
        this.localMap.put(key, value == null ? NULL_OBJECT : value);
    }

    protected Cache getDelegateCache() {
        return this.delegateCache;
    }

    protected void destroy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Destroying cache: " + this.cacheName);
        }
        for (Object key : this.localMap.keySet()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Evicting cache key on destroy: " + this.cacheName + ":" + key);
            }
            this.delegateCache.evict(key);
        }
    }

    protected static class KeyWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Object uniqueKey;
        Object key;

        public KeyWrapper(Object uniqueKey, Object key) {
            this.uniqueKey = uniqueKey;
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.uniqueKey == null ? 0 : this.uniqueKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyWrapper other = (KeyWrapper)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.uniqueKey == null ? other.uniqueKey != null : !this.uniqueKey.equals(other.uniqueKey));
        }
    }
}

