/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire;

import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;

public class GemfireLockServiceFactoryBean
implements FactoryBean<DistributedLockService> {
    private static final Logger LOGGER = LogManager.getLogger(GemfireLockServiceFactoryBean.class);
    private Cache cache;
    private String lockServiceName;
    private DistributedLockService lockService;

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Required
    public void setLockServiceName(String lockServiceName) {
        this.lockServiceName = lockServiceName;
    }

    public synchronized DistributedLockService getObject() throws Exception {
        block4: {
            if (this.lockService != null) {
                return this.lockService;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating lock service: " + this.lockServiceName);
            }
            try {
                this.lockService = DistributedLockService.create((String)this.lockServiceName, (DistributedSystem)this.cache.getDistributedSystem());
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("IllegalArgumentException creating DistributedLockService", (Throwable)e);
                this.lockService = DistributedLockService.getServiceNamed((String)this.lockServiceName);
                if (this.lockService != null) break block4;
                LOGGER.error("Couldn't create DistributedLockService", (Throwable)e);
                throw e;
            }
        }
        return this.lockService;
    }

    public Class<?> getObjectType() {
        return DistributedLockService.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

