/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.data.caches.gemfire;

import com.sas.svcs.commons.util.EventingMap;
import com.sas.svcs.commons.util.EventingMapEvent;
import com.sas.svcs.commons.util.EventingMapListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.task.TaskExecutor;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class GemfireEventingMap<K, V>
extends CacheListenerAdapter<K, V>
implements EventingMap<K, V>,
CacheListener<K, V> {
    private static final Logger LOGGER = LogManager.getLogger(GemfireEventingMap.class);
    private final Region<K, V> region;
    private final List<EventingMapListener<K, V>> listeners = new ArrayList<EventingMapListener<K, V>>();
    private final TaskExecutor taskExecutor;

    public GemfireEventingMap(Region<K, V> region, TaskExecutor taskExecutor) {
        this.region = region;
        this.taskExecutor = taskExecutor;
        region.getAttributesMutator().addCacheListener((CacheListener)this);
    }

    public void addListener(EventingMapListener<K, V> listener) {
        this.listeners.add(listener);
    }

    public int size() {
        return this.region.size();
    }

    public boolean isEmpty() {
        return this.region.isEmpty();
    }

    public boolean containsKey(Object paramObject) {
        return this.region.containsKey(paramObject);
    }

    public boolean containsValue(Object paramObject) {
        return this.region.containsValue(paramObject);
    }

    public V get(Object paramObject) {
        return (V)this.region.get(paramObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K paramK, V paramV) {
        SecurityContext sc = SecurityContextHolder.getContext();
        try {
            SecurityContextHolder.clearContext();
            Object object = this.region.put(paramK, paramV);
            return (V)object;
        }
        finally {
            if (null != sc.getAuthentication()) {
                SecurityContextHolder.setContext((SecurityContext)sc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object paramObject) {
        SecurityContext sc = SecurityContextHolder.getContext();
        try {
            SecurityContextHolder.clearContext();
            Object object = this.region.remove(paramObject);
            return (V)object;
        }
        finally {
            if (null != sc.getAuthentication()) {
                SecurityContextHolder.setContext((SecurityContext)sc);
            }
        }
    }

    public void putAll(Map<? extends K, ? extends V> paramMap) {
        SecurityContext sc = SecurityContextHolder.getContext();
        try {
            SecurityContextHolder.clearContext();
            this.region.putAll(paramMap);
        }
        finally {
            if (null != sc.getAuthentication()) {
                SecurityContextHolder.setContext((SecurityContext)sc);
            }
        }
    }

    public void clear() {
        this.region.clear();
    }

    public Set<K> keySet() {
        return this.region.keySet();
    }

    public Collection<V> values() {
        return this.region.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.region.entrySet();
    }

    public void afterCreate(EntryEvent<K, V> event) {
        final EventingMapEvent eventMappingEvent = new EventingMapEvent(event.getKey(), event.getNewValue(), EventingMapEvent.EventType.ADDED);
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    GemfireEventingMap.this.fireAddListeners(eventMappingEvent);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origClassLoader);
                }
            }
        });
    }

    public void afterDestroy(EntryEvent<K, V> event) {
        final EventingMapEvent eventMappingEvent = new EventingMapEvent(event.getKey(), event.getOldValue(), EventingMapEvent.EventType.REMOVED);
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    GemfireEventingMap.this.fireRemoveListeners(eventMappingEvent);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origClassLoader);
                }
            }
        });
    }

    public void afterUpdate(EntryEvent<K, V> event) {
        final EventingMapEvent eventMappingEvent = new EventingMapEvent(event.getKey(), event.getNewValue(), EventingMapEvent.EventType.UPDATED);
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    GemfireEventingMap.this.fireUpdateListeners(eventMappingEvent);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origClassLoader);
                }
            }
        });
    }

    private void fireAddListeners(EventingMapEvent<K, V> event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("fireAddListeners: key=" + event.getKey() + ", type=" + event.getType() + ", value=" + event.getValue());
        }
        for (EventingMapListener<K, V> listener : this.listeners) {
            listener.entryAdded(event);
        }
    }

    private void fireUpdateListeners(EventingMapEvent<K, V> event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("fireUpdateListeners: key=" + event.getKey() + ", type=" + event.getType() + ", value=" + event.getValue());
        }
        for (EventingMapListener<K, V> listener : this.listeners) {
            listener.entryUpdated(event);
        }
    }

    private void fireRemoveListeners(EventingMapEvent<K, V> event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("fireRemoveListeners: key=" + event.getKey() + ", type=" + event.getType() + ", value=" + event.getValue());
        }
        for (EventingMapListener<K, V> listener : this.listeners) {
            listener.entryRemoved(event);
        }
    }
}

