/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.utils.MnemonicModel;
import com.sas.console.visuals.ConsoleAction;
import com.sas.console.visuals.SubmenuAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MenuButton
extends JToggleButton {
    private static final long serialVersionUID = 9200000001L;
    protected SubmenuAction m_action;
    protected JPopupMenu m_popupMenu;

    public MenuButton(SubmenuAction action) {
        this.m_action = action;
        this._initialize();
    }

    protected void onActionPerformed(ActionEvent evt) {
        if (this.isSelected() && this.m_popupMenu != null && this.m_popupMenu.isShowing()) {
            this.m_popupMenu.setVisible(false);
        }
        this.m_popupMenu = new JPopupMenu();
        this.m_popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                MenuButton.this.setSelected(false);
                MenuButton.this.setFocusPainted(false);
                MenuButton.this.setBorderPainted(false);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                MenuButton.this.setSelected(true);
            }
        });
        List actionsList = this.m_action.getActions();
        for (int i = 0; i < actionsList.size(); ++i) {
            Action action = (Action)actionsList.get(i);
            if (action instanceof SubmenuAction) {
                SubmenuAction submenuAction = (SubmenuAction)action;
                JMenu submenu = SubmenuAction.generateSubmenu(submenuAction);
                this.m_popupMenu.add(submenu);
                continue;
            }
            if (action == null) {
                this.m_popupMenu.addSeparator();
                continue;
            }
            ConsoleAction consoleAction = new ConsoleAction(action);
            this.m_popupMenu.add(MnemonicModel.getMenuItemWithMnemonic(consoleAction));
        }
        if (this.m_popupMenu.getSubElements().length != 0) {
            JComponent source = (JComponent)evt.getSource();
            source.add(this.m_popupMenu);
            this.m_popupMenu.show(source, 1, this.getHeight());
        }
    }

    protected void _initialize() {
        this.setAction(this.m_action);
        this.setText((String)this.m_action.getValue("Name"));
        this.setIcon((Icon)this.m_action.getValue("SmallIcon"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuButton.this.onActionPerformed(evt);
            }
        });
    }
}

