/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.ConsoleInterface;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.CustomTableColumnInterface;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.plugins.CustomTablePane;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.utils.MnemonicModel;
import com.sas.console.utils.ServerUtil;
import com.sas.console.utils.WindowUtil;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.console.visuals.MainConsole;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalObjectPropertyDialogInterface;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.visuals.Resources;
import com.sas.wadmin.visuals.JOMANotesTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.plugins.PluginViewInterface;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;

public class CustomTablePropertyAction
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    protected CustomTableInterface m_customTable;
    protected NodeInterface m_node;
    protected ElementInterface m_element;
    protected ChildServerInterface m_transaction;
    protected MetadataInterface m_smartObject;
    protected static WAdminResource bundle = new WAdminResource(CustomTablePropertyAction.class);

    public CustomTablePropertyAction(CustomTableInterface customTable) {
        super("properties");
        this.m_customTable = customTable;
        this._initialize();
    }

    protected void _initialize() {
        this.putValue("Default", "PropertyAction.");
        this.putValue("LongDescription", this._getValueFromBundle("Long"));
        MnemonicModel.setActionTextAndMnemonic(this, this._getValueFromBundle("Name"), this._getValueFromBundle("Short"), Resources.getImageIcon((String)bundle.getString("PropertyAction.Icon.image"), (int)16));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CustomTablePane customTablePane;
        int itemIndex;
        String helpProduct;
        List lstPropTabs;
        CustomTableColumnInterface m_column = this.m_customTable.getCurrentColumn();
        int[] rows = this.m_customTable.getSelectedRows();
        if (rows.length < 1) {
            return;
        }
        int m_selectedRow = rows[0];
        this.m_element = m_column.getElementInterface(m_selectedRow);
        this.m_node = this.m_element.getNode();
        ArrayList tabList = new ArrayList(0);
        Root copyRoot = null;
        int currentViewType = ConsoleViewManager.getCurrentViewType();
        String strTitle = bundle.formatString("PropertyAction.Title.fmt.txt", (Object)this.m_element.getName());
        if (this.m_element.getName().length() == 0) {
            strTitle = bundle.getString("PropertyAction.Title.txt");
        }
        WAPropertyDialog dialog = new WAPropertyDialog((Frame)MainConsole.getWorkspace(), strTitle, true);
        if ((currentViewType == 1 || currentViewType == 2) && this.m_element instanceof TableItem) {
            TableItem ti = (TableItem)this.m_element;
            LogicalObjectInterface loi = ti.getLogicalObjectInterface();
            Factory loiFactory = Factory.getInstance();
            if (loi != null && loiFactory.isSmartObjectBasedDialog(loi)) {
                List smartTabs = new ArrayList();
                ObjectFactoryInterface ofi = null;
                TypeInterface typei = loi.getTypeInterface();
                if (ti != null) {
                    ofi = typei.getObjectFactory();
                }
                try {
                    ServerInterface si = ServerUtil.getServerInterface();
                    ChildServerInterface transaction = si.newChild(true);
                    String smartObjectKey = loi.getID() + "/" + loi.getTypeInterface().getMetadataType();
                    this.m_smartObject = transaction.fetch(smartObjectKey, true);
                    if (ofi != null && ofi instanceof LogicalObjectPropertyDialogInterface) {
                        dialog = ((LogicalObjectPropertyDialogInterface)ofi).getPropertyDialog((Frame)MainConsole.getWorkspace(), strTitle, true, loi);
                    }
                    smartTabs = loiFactory.getPropertyTabs(loi, transaction, this.m_smartObject, (Root)this.m_smartObject.getRepositoryEntity(), null);
                    tabList.addAll(smartTabs);
                    dialog.setMetadataServiceObject(this.m_smartObject);
                }
                catch (RemoteException re) {
                    Workspace.getDefaultLogger().error((Object)"Failed to get properties for smart object:", (Throwable)re);
                }
                catch (ServiceException se) {
                    Workspace.getDefaultLogger().error((Object)"Failed to get properties for smart object:", (Throwable)se);
                }
                catch (MdException me) {
                    Workspace.getDefaultLogger().error((Object)"Failed to get properties for smart object:", (Throwable)me);
                }
            }
        }
        if (tabList.isEmpty() && (lstPropTabs = this.m_element.getPropertyTabs()) != null) {
            tabList.addAll(lstPropTabs);
        }
        Root metaObject = this.m_element.getMetadataObject();
        if (tabList == null || tabList.size() == 0) {
            if (metaObject != null) {
                copyRoot = Server.createNewEditableObject((Root)metaObject);
            }
            if (copyRoot != null) {
                WAGeneralPropertyTab generalTab = new WAGeneralPropertyTab((CMetadata)copyRoot);
                JOMANotesTab notesTab = new JOMANotesTab(copyRoot);
                WAExtAttrPropertyTab extAttrTab = new WAExtAttrPropertyTab((CMetadata)copyRoot);
                generalTab.setName(bundle.getString("PropertyAction.GeneralTab.txt"));
                notesTab.setName(bundle.getString("PropertyAction.NotesTab.txt"));
                extAttrTab.setName(bundle.getString("PropertyAction.ExtAttrTab.txt"));
                tabList.add(generalTab);
                tabList.add(notesTab);
                tabList.add(extAttrTab);
            } else {
                String strMessage = bundle.getString("PropertyAction.Message.NoProperties.txt");
                MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)1);
                return;
            }
        }
        if ((helpProduct = this._getHelpProduct()) != null) {
            dialog.setHelpProduct(helpProduct);
        }
        if (this.m_smartObject == null) {
            if (copyRoot != null) {
                dialog.setMetadataObject((CMetadata)copyRoot);
            } else {
                dialog.setMetadataObject((CMetadata)metaObject);
            }
        }
        List extendedTabList = this.getExtendedPropertyTabs(metaObject);
        tabList.addAll(extendedTabList);
        for (int index = 0; index < tabList.size(); ++index) {
            WAPropertyTab tab = (WAPropertyTab)tabList.get(index);
            dialog.addTab(tab.getName(), tab);
        }
        dialog.pack();
        WindowUtil.center((Window)dialog);
        dialog.setVisible(true);
        if (dialog.getReturnValue() == 1 && (itemIndex = (customTablePane = (CustomTablePane)this.m_customTable).convertRowIndexToView(m_selectedRow)) > -1) {
            this.m_customTable.refreshRow(m_selectedRow);
        }
    }

    protected String _getValueFromBundle(String strValueName) {
        return bundle.getRawString(this.getValue("Default") + strValueName + ".txt");
    }

    protected String _getHelpProduct() {
        if (this.m_node == null || this.m_node instanceof BIAbstractNode || this.m_node.getPlugin() == null) {
            return "";
        }
        String pluginName = this.m_node.getPlugin().getClass().getName();
        int index = pluginName.lastIndexOf(".");
        pluginName = pluginName.substring(0, index);
        index = pluginName.lastIndexOf(".");
        pluginName = pluginName.substring(index + 1, pluginName.length());
        pluginName = pluginName.toLowerCase();
        return pluginName;
    }

    protected List getExtendedPropertyTabs(Root metaObject) {
        ConsoleInterface console = ConsoleViewManager.getConsole();
        List extraViewList = console.getExtendedPropertyTabs(this.m_element);
        MainConsole mainConsole = (MainConsole)console;
        List extensionPlugins = mainConsole.getExtensionPlugins();
        for (int i = 0; i < extensionPlugins.size(); ++i) {
            Object extPlugin = extensionPlugins.get(i);
            if (!(extPlugin instanceof PluginViewInterface)) continue;
            PluginViewInterface viewPlugin = (PluginViewInterface)extPlugin;
            ArrayList metaPropTabs = viewPlugin.getPropertyTabs((CMetadata)metaObject);
            extraViewList.addAll(metaPropTabs);
        }
        return extraViewList;
    }

    protected void handlePropertiesException(Exception e) {
        MessageUtil.displayDetailsMessage((String)"Properties could not be shown for this item", (String)e.getLocalizedMessage());
    }
}

