/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.ConsoleInterface;
import com.sas.console.folderview.visuals.ConsoleFolderTree;
import com.sas.console.folderview.visuals.ConsoleFolderView;
import com.sas.console.folderview.visuals.FolderTreeModel;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.utils.CustomTableUtil;
import com.sas.console.visuals.ConsolePluginTree;
import com.sas.console.visuals.ConsoleTable;
import com.sas.console.visuals.ConsoleTree;
import com.sas.console.visuals.ConsoleViewInterface;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.console.visuals.MainConsole;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeSelectionModel;

public class ConsoleTreeSelectionListener
implements TreeSelectionListener {
    MainConsole m_console;
    ConsoleViewInterface m_currentView;
    NodeInterface m_currentNode;
    TreeSelectionModel m_selectionModel;
    CustomViewInterface m_customView;
    JTree m_owningTree;

    public ConsoleTreeSelectionListener(ConsoleInterface console, JTree owningTree) {
        this.m_console = (MainConsole)console;
        this.m_owningTree = owningTree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.onNodeSelected();
    }

    public void onNodeSelected() {
        this.m_console.checkIServerStatus();
        this.m_currentView = ConsoleViewManager.getCurrentView();
        int currentViewType = this.m_currentView.getType();
        if (currentViewType == 2) {
            return;
        }
        ConsoleTree tree = (ConsoleTree)this.m_currentView.getComponent();
        NodeInterface node = (NodeInterface)tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.m_currentNode = this.m_console.getCurrentNode();
        this.m_customView = this.m_console.getCustomView();
        currentViewType = this.m_currentView.getType();
        int lastViewType = this.m_console.getViewLastSelected();
        this.m_selectionModel = tree.getSelectionModel();
        ConsoleTable table = this.m_console.getTable();
        ConsoleFolderView folderView = (ConsoleFolderView)this.m_console.getConsoleView(1);
        this.m_console.setViewLastSelected(this.m_currentView.getType());
        this.m_console.setTreeLastSelected(true);
        if (currentViewType != ConsoleViewManager.getCurrentViewType()) {
            return;
        }
        if (node != this.m_currentNode && lastViewType > -1) {
            ConsoleViewManager.getView(lastViewType).cleanupChangeListeners(this.m_currentNode);
        }
        this.m_console.setCurrentNode(node);
        this.m_currentNode = node;
        this.m_console.fireConsoleChange(8);
        CustomTableUtil.saveSettings(this.m_customView);
        this.m_console._displayNode(this.m_currentNode);
        if (table != null) {
            table.clearSelection();
        }
        this.m_console.updateMenuBar(true);
        if (currentViewType == 0) {
            if (this.m_currentNode.getParent() != null) {
                ((NodeInterface)this.m_currentNode.getParent()).getPlugin().addPluginChangeListener((ConsolePluginTree.ConsoleTreeSelectionModel)this.m_selectionModel);
            } else {
                this.m_currentNode.getPlugin().addPluginChangeListener((ConsolePluginTree.ConsoleTreeSelectionModel)this.m_selectionModel);
            }
        } else if (currentViewType == 1) {
            folderView.addFolderViewListener((ConsoleFolderTree.FolderTreeSelectionModel)tree.getSelectionModel());
            folderView.addFolderViewListener((FolderTreeModel)tree.getModel());
        }
        this.m_console.m_toolBarUpdated = true;
    }
}

